/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.core.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.core.data.ais.AisConsentData;
import de.adorsys.psd2.core.data.piis.v1.PiisConsentData;
import de.adorsys.psd2.mapper.config.ObjectMapperConfig;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ConsentDataMapper {
    private static final Logger log = LoggerFactory.getLogger(ConsentDataMapper.class);
    private final ObjectMapper objectMapper = this.buildObjectMapper();

    public AisConsentData mapToAisConsentData(byte[] consentData) {
        if (consentData == null) {
            return AisConsentData.buildDefaultAisConsentData();
        }
        try {
            return (AisConsentData)this.objectMapper.readValue(consentData, AisConsentData.class);
        }
        catch (IOException e) {
            log.info("Can't convert byte[] to AisConsentData: {}", (Object)e.getMessage());
            return null;
        }
    }

    public PiisConsentData mapToPiisConsentData(byte[] consentData) {
        if (consentData == null) {
            return PiisConsentData.buildDefaultConsentData();
        }
        try {
            return (PiisConsentData)this.objectMapper.readValue(consentData, PiisConsentData.class);
        }
        catch (IOException e) {
            log.info("Can't convert byte[] to PiisConsentData: {}", (Object)e.getMessage());
            return null;
        }
    }

    public byte[] getBytesFromConsentData(Object consentData) {
        try {
            return this.objectMapper.writeValueAsBytes(consentData);
        }
        catch (JsonProcessingException e) {
            log.info("Can't convert consentData to byte[]: {}", (Object)e.getMessage());
            return new byte[0];
        }
    }

    private ObjectMapper buildObjectMapper() {
        ObjectMapperConfig objectMapperConfig = new ObjectMapperConfig();
        return objectMapperConfig.xs2aObjectMapper();
    }
}

