/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.core.data.piis.v1;

import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.core.data.Consent;
import de.adorsys.psd2.core.data.piis.v1.PiisConsentData;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationTemplate;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.consent.ConsentTppInformation;
import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class PiisConsent
extends Consent<PiisConsentData> {
    public PiisConsent() {
    }

    public PiisConsent(PiisConsentData consentData, String id, String internalRequestId, ConsentStatus consentStatus, boolean recurringIndicator, LocalDate expireDate, LocalDate lastActionDate, OffsetDateTime creationTimestamp, ConsentTppInformation consentTppInformation, List<PsuIdData> psuIdDataList, AccountAccess aspspAccountAccess) {
        super(consentData, id, internalRequestId, consentStatus, 0, recurringIndicator, false, null, expireDate, lastActionDate, creationTimestamp, null, consentTppInformation, new AuthorisationTemplate(), psuIdDataList, Collections.emptyList(), Collections.emptyMap(), AccountAccess.EMPTY_ACCESS, aspspAccountAccess);
    }

    @Override
    public ConsentType getConsentType() {
        return ConsentType.PIIS_ASPSP;
    }

    public AccountReference getAccountReference() {
        List<AccountReference> accounts = this.getAspspAccountAccesses().getAccounts();
        if (CollectionUtils.isNotEmpty(accounts)) {
            return accounts.get(0);
        }
        return null;
    }

    public PsuIdData getPsuIdData() {
        List<PsuIdData> psuIdDataList = this.getPsuIdDataList();
        if (CollectionUtils.isNotEmpty(psuIdDataList)) {
            return psuIdDataList.get(0);
        }
        return null;
    }
}

