/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.core.data.ais;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.core.data.Consent;
import de.adorsys.psd2.core.data.ais.AisConsentData;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.consent.AisConsentRequestType;
import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AisConsent
extends Consent<AisConsentData> {
    public AisConsent() {
        this.setConsentType(ConsentType.AIS);
    }

    @JsonIgnore
    public AccountAccess getAccess() {
        Optional<AccountAccessType> allPsd2Optional = Optional.ofNullable((AisConsentData)this.getConsentData()).map(AisConsentData::getAllPsd2);
        if (allPsd2Optional.isPresent()) {
            return this.getTppAccountAccesses();
        }
        AccountAccess aspspAccountAccesses = this.getAspspAccountAccesses();
        if (aspspAccountAccesses.isNotEmpty((AisConsentData)this.getConsentData())) {
            return aspspAccountAccesses;
        }
        return this.getTppAccountAccesses();
    }

    public boolean isWithBalance() {
        return CollectionUtils.isNotEmpty(this.getTppAccountAccesses().getBalances()) || ((AisConsentData)this.getConsentData()).getAvailableAccountsWithBalance() != null || this.isGlobalConsent();
    }

    @JsonIgnore
    public boolean isOneAccessType() {
        return !this.isRecurringIndicator();
    }

    @JsonIgnore
    public boolean isWrongConsentData() {
        return CollectionUtils.isEmpty(this.getPsuIdDataList()) || this.getConsentTppInformation() == null || this.getConsentTppInformation().getTppInfo() == null;
    }

    @JsonIgnore
    public boolean isGlobalConsent() {
        return this.getConsentRequestType() == AisConsentRequestType.GLOBAL;
    }

    @JsonIgnore
    public boolean isConsentForAllAvailableAccounts() {
        return this.getConsentRequestType() == AisConsentRequestType.ALL_AVAILABLE_ACCOUNTS;
    }

    @JsonIgnore
    public boolean isConsentForDedicatedAccounts() {
        return this.getConsentRequestType() == AisConsentRequestType.DEDICATED_ACCOUNTS;
    }

    @JsonIgnore
    public boolean isBankOfferedConsent() {
        return this.getConsentRequestType() == AisConsentRequestType.BANK_OFFERED;
    }

    public boolean isConsentWithNotIbanAccount() {
        AccountAccess access = this.getAccess();
        if (access == null) {
            return false;
        }
        return Stream.of(access.getAccounts(), access.getBalances(), access.getTransactions()).filter(Objects::nonNull).flatMap(Collection::stream).allMatch(acc -> StringUtils.isAllBlank((CharSequence[])new CharSequence[]{acc.getIban(), acc.getBban(), acc.getMsisdn()}));
    }

    public boolean isConsentWithNotCardAccount() {
        AccountAccess access = this.getAccess();
        if (access == null) {
            return false;
        }
        return Stream.of(access.getAccounts(), access.getBalances(), access.getTransactions()).filter(Objects::nonNull).flatMap(Collection::stream).allMatch(acc -> StringUtils.isAllBlank((CharSequence[])new CharSequence[]{acc.getMaskedPan(), acc.getPan()}));
    }

    public Map<String, Integer> getUsageCounterMap() {
        return this.getUsages();
    }

    public AisConsentRequestType getAisConsentRequestType() {
        return this.getConsentRequestType();
    }

    @JsonIgnore
    public AisConsentRequestType getConsentRequestType() {
        AccountAccess usedAccess = this.getAccess();
        return this.getRequestType(((AisConsentData)this.getConsentData()).getAllPsd2(), ((AisConsentData)this.getConsentData()).getAvailableAccounts(), ((AisConsentData)this.getConsentData()).getAvailableAccountsWithBalance(), !usedAccess.isNotEmpty((AisConsentData)this.getConsentData()));
    }

    private AisConsentRequestType getRequestType(AccountAccessType allPsd2, AccountAccessType availableAccounts, AccountAccessType availableAccountsWithBalance, boolean isAccessesEmpty) {
        List<AccountAccessType> allAccountsType = Arrays.asList(AccountAccessType.ALL_ACCOUNTS, AccountAccessType.ALL_ACCOUNTS_WITH_OWNER_NAME);
        if (allAccountsType.contains(allPsd2)) {
            return AisConsentRequestType.GLOBAL;
        }
        if (allAccountsType.contains(availableAccounts)) {
            return AisConsentRequestType.ALL_AVAILABLE_ACCOUNTS;
        }
        if (allAccountsType.contains(availableAccountsWithBalance)) {
            return AisConsentRequestType.ALL_AVAILABLE_ACCOUNTS;
        }
        if (isAccessesEmpty) {
            return AisConsentRequestType.BANK_OFFERED;
        }
        return AisConsentRequestType.DEDICATED_ACCOUNTS;
    }

    protected AisConsent(AisConsentBuilder<?, ?> b) {
        super(b);
    }

    public static AisConsentBuilder<?, ?> builder() {
        return new AisConsentBuilderImpl();
    }

    private static final class AisConsentBuilderImpl
    extends AisConsentBuilder<AisConsent, AisConsentBuilderImpl> {
        private AisConsentBuilderImpl() {
        }

        @Override
        protected AisConsentBuilderImpl self() {
            return this;
        }

        @Override
        public AisConsent build() {
            return new AisConsent(this);
        }
    }

    public static abstract class AisConsentBuilder<C extends AisConsent, B extends AisConsentBuilder<C, B>>
    extends Consent.ConsentBuilder<AisConsentData, C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "AisConsent.AisConsentBuilder(super=" + super.toString() + ")";
        }
    }
}

