/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.core.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.psd2.core.data.ais.AisConsentData;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.AdditionalInformationAccess;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public final class AccountAccess {
    public static final AccountAccess EMPTY_ACCESS = new AccountAccess(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), new AdditionalInformationAccess(Collections.emptyList(), Collections.emptyList()));
    private final List<AccountReference> accounts;
    private final List<AccountReference> balances;
    private final List<AccountReference> transactions;
    private final AdditionalInformationAccess additionalInformationAccess;

    @JsonIgnore
    public boolean isNotEmpty(AisConsentData aisConsentData) {
        return !CollectionUtils.isEmpty(this.accounts) || !CollectionUtils.isEmpty(this.balances) || !CollectionUtils.isEmpty(this.transactions) || aisConsentData.getAllPsd2() != null || aisConsentData.getAvailableAccounts() != null || aisConsentData.getAvailableAccountsWithBalance() != null;
    }

    @ConstructorProperties(value={"accounts", "balances", "transactions", "additionalInformationAccess"})
    public AccountAccess(List<AccountReference> accounts, List<AccountReference> balances, List<AccountReference> transactions, AdditionalInformationAccess additionalInformationAccess) {
        this.accounts = accounts;
        this.balances = balances;
        this.transactions = transactions;
        this.additionalInformationAccess = additionalInformationAccess;
    }

    public List<AccountReference> getAccounts() {
        return this.accounts;
    }

    public List<AccountReference> getBalances() {
        return this.balances;
    }

    public List<AccountReference> getTransactions() {
        return this.transactions;
    }

    public AdditionalInformationAccess getAdditionalInformationAccess() {
        return this.additionalInformationAccess;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountAccess)) {
            return false;
        }
        AccountAccess other = (AccountAccess)o;
        List<AccountReference> this$accounts = this.getAccounts();
        List<AccountReference> other$accounts = other.getAccounts();
        if (this$accounts == null ? other$accounts != null : !((Object)this$accounts).equals(other$accounts)) {
            return false;
        }
        List<AccountReference> this$balances = this.getBalances();
        List<AccountReference> other$balances = other.getBalances();
        if (this$balances == null ? other$balances != null : !((Object)this$balances).equals(other$balances)) {
            return false;
        }
        List<AccountReference> this$transactions = this.getTransactions();
        List<AccountReference> other$transactions = other.getTransactions();
        if (this$transactions == null ? other$transactions != null : !((Object)this$transactions).equals(other$transactions)) {
            return false;
        }
        AdditionalInformationAccess this$additionalInformationAccess = this.getAdditionalInformationAccess();
        AdditionalInformationAccess other$additionalInformationAccess = other.getAdditionalInformationAccess();
        return !(this$additionalInformationAccess == null ? other$additionalInformationAccess != null : !this$additionalInformationAccess.equals(other$additionalInformationAccess));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<AccountReference> $accounts = this.getAccounts();
        result = result * 59 + ($accounts == null ? 43 : ((Object)$accounts).hashCode());
        List<AccountReference> $balances = this.getBalances();
        result = result * 59 + ($balances == null ? 43 : ((Object)$balances).hashCode());
        List<AccountReference> $transactions = this.getTransactions();
        result = result * 59 + ($transactions == null ? 43 : ((Object)$transactions).hashCode());
        AdditionalInformationAccess $additionalInformationAccess = this.getAdditionalInformationAccess();
        result = result * 59 + ($additionalInformationAccess == null ? 43 : $additionalInformationAccess.hashCode());
        return result;
    }

    public String toString() {
        return "AccountAccess(accounts=" + this.getAccounts() + ", balances=" + this.getBalances() + ", transactions=" + this.getTransactions() + ", additionalInformationAccess=" + this.getAdditionalInformationAccess() + ")";
    }
}

