/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.impl;

import de.adorsys.aspsp.xs2a.spi.component.SpiMockJsonConverter;
import de.adorsys.aspsp.xs2a.spi.config.rest.AspspRemoteUrls;
import de.adorsys.aspsp.xs2a.spi.impl.service.KeycloakInvokerService;
import de.adorsys.psd2.xs2a.core.consent.AisConsentRequestType;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.sca.ChallengeData;
import de.adorsys.psd2.xs2a.exception.RestException;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthenticationObject;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationDecoupledScaResponse;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorizationCodeResult;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaConfirmation;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiAccountAccess;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiInitiateAisConsentResponse;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiVerifyScaAuthorisationResponse;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponseStatus;
import de.adorsys.psd2.xs2a.spi.service.AisConsentSpi;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class AisConsentSpiImpl
implements AisConsentSpi {
    private static final Logger log = LoggerFactory.getLogger(AisConsentSpiImpl.class);
    private static final String DECOUPLED_PSU_MESSAGE = "Please use your BankApp for transaction Authorisation";
    private final AspspRemoteUrls remoteSpiUrls;
    @Qualifier(value="aspspRestTemplate")
    private final RestTemplate aspspRestTemplate;
    private final KeycloakInvokerService keycloakInvokerService;
    private final SpiMockJsonConverter jsonConverter;
    private static final String TEST_ASPSP_DATA = "Test aspsp data";
    private static final String TEST_MESSAGE = "Test message";
    private static final String TEST_PSU_MESSAGE = "This test message is created in ASPSP and directed to PSU";

    public SpiResponse<SpiInitiateAisConsentResponse> initiateAisConsent(@NotNull SpiContextData spiContextData, SpiAccountConsent accountConsent, AspspConsentData initialAspspConsentData) {
        log.info("AisConsentSpi initiateAisConsent() mock implementation");
        try {
            SpiAccountAccess access = accountConsent.getAccess();
            if (EnumSet.of(AisConsentRequestType.GLOBAL, AisConsentRequestType.BANK_OFFERED).contains(accountConsent.getAisConsentRequestType())) {
                List accountDetailsByPsuId = this.getAccountDetailsByPsuId(accountConsent);
                List spiAccountReferences = accountDetailsByPsuId.stream().map(SpiAccountReference::new).collect(Collectors.toList());
                access.setAccounts(spiAccountReferences);
                access.setTransactions(spiAccountReferences);
                if (accountConsent.isWithBalance()) {
                    access.setBalances(spiAccountReferences);
                }
            } else {
                access = this.getAccountDetailsFromReferences(accountConsent);
            }
            String psuMessage = Optional.ofNullable(spiContextData.getPsuData()).filter(psu -> StringUtils.isNotBlank((CharSequence)psu.getPsuId())).map(psu -> TEST_PSU_MESSAGE).orElse(null);
            return SpiResponse.builder().payload((Object)new SpiInitiateAisConsentResponse(access, false, psuMessage)).aspspConsentData(initialAspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(initialAspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(initialAspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    public SpiResponse<SpiResponse.VoidResponse> revokeAisConsent(@NotNull SpiContextData spiContextData, SpiAccountConsent accountConsent, AspspConsentData aspspConsentData) {
        log.info("AisConsentSpi revokeAisConsent() mock implementation");
        return SpiResponse.builder().payload((Object)SpiResponse.voidResponse()).aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).message(Collections.singletonList(TEST_MESSAGE)).success();
    }

    public SpiResponse<SpiAuthorisationStatus> authorisePsu(@NotNull SpiContextData spiContextData, @NotNull SpiPsuData psuLoginData, String password, SpiAccountConsent accountConsent, @NotNull AspspConsentData aspspConsentData) {
        try {
            Optional accessToken = this.keycloakInvokerService.obtainAuthorisationData(psuLoginData.getPsuId(), password);
            SpiAuthorisationStatus spiAuthorisationStatus = accessToken.map(t -> SpiAuthorisationStatus.SUCCESS).orElse(SpiAuthorisationStatus.FAILURE);
            byte[] payload = accessToken.flatMap(arg_0 -> ((SpiMockJsonConverter)this.jsonConverter).toJson(arg_0)).map(String::getBytes).orElse(null);
            if (spiAuthorisationStatus == SpiAuthorisationStatus.FAILURE) {
                return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(payload)).fail(SpiResponseStatus.UNAUTHORIZED_FAILURE);
            }
            return new SpiResponse((Object)spiAuthorisationStatus, aspspConsentData.respondWith(payload));
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    public SpiResponse<List<SpiAuthenticationObject>> requestAvailableScaMethods(@NotNull SpiContextData spiContextData, SpiAccountConsent accountConsent, @NotNull AspspConsentData aspspConsentData) {
        try {
            ResponseEntity response = this.aspspRestTemplate.exchange(this.remoteSpiUrls.getScaMethods(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{spiContextData.getPsuData().getPsuId()});
            List spiScaMethods = Optional.ofNullable(response.getBody()).orElseGet(Collections::emptyList);
            return new SpiResponse((Object)spiScaMethods, aspspConsentData);
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @NotNull
    public SpiResponse<SpiAuthorizationCodeResult> requestAuthorisationCode(@NotNull SpiContextData spiContextData, @NotNull String authenticationMethodId, @NotNull SpiAccountConsent accountConsent, @NotNull AspspConsentData aspspConsentData) {
        try {
            this.aspspRestTemplate.exchange(this.remoteSpiUrls.getGenerateTanConfirmationForAis(), HttpMethod.POST, null, Void.class, new Object[]{spiContextData.getPsuData().getPsuId()});
            return SpiResponse.builder().payload((Object)this.getDefaultSpiAuthorizationCodeResult()).aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).message(Collections.singletonList(TEST_MESSAGE)).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @NotNull
    public SpiResponse<SpiVerifyScaAuthorisationResponse> verifyScaAuthorisation(@NotNull SpiContextData spiContextData, @NotNull SpiScaConfirmation spiScaConfirmation, @NotNull SpiAccountConsent accountConsent, @NotNull AspspConsentData aspspConsentData) {
        try {
            this.aspspRestTemplate.exchange(this.remoteSpiUrls.applyStrongUserAuthorisationForAis(), HttpMethod.PUT, new HttpEntity((Object)spiScaConfirmation), Void.class, new Object[0]);
            return SpiResponse.builder().payload((Object)new SpiVerifyScaAuthorisationResponse(ConsentStatus.VALID)).aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).message(Collections.singletonList(TEST_MESSAGE)).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @NotNull
    public SpiResponse<SpiAuthorisationDecoupledScaResponse> startScaDecoupled(@NotNull SpiContextData contextData, @NotNull String authorisationId, @Nullable String authenticationMethodId, @NotNull SpiAccountConsent businessObject, @NotNull AspspConsentData aspspConsentData) {
        SpiAuthorisationDecoupledScaResponse response = new SpiAuthorisationDecoupledScaResponse(DECOUPLED_PSU_MESSAGE);
        return SpiResponse.builder().payload((Object)response).aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).success();
    }

    private SpiAuthorizationCodeResult getDefaultSpiAuthorizationCodeResult() {
        SpiAuthenticationObject method = new SpiAuthenticationObject();
        method.setAuthenticationMethodId("sms");
        method.setAuthenticationType("SMS_OTP");
        ChallengeData challengeData = new ChallengeData(null, "some data", "some link", Integer.valueOf(100), null, "info");
        SpiAuthorizationCodeResult resultTmp = new SpiAuthorizationCodeResult();
        resultTmp.setChallengeData(challengeData);
        resultTmp.setSelectedScaMethod(method);
        return resultTmp;
    }

    private List<SpiAccountDetails> getAccountDetailsByPsuId(SpiAccountConsent accountConsent) {
        String psuId = CollectionUtils.isNotEmpty((Collection)accountConsent.getPsuData()) ? ((SpiPsuData)accountConsent.getPsuData().get(0)).getPsuId() : null;
        return Optional.ofNullable(this.aspspRestTemplate.exchange(this.remoteSpiUrls.getAccountDetailsByPsuId(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{psuId}).getBody()).orElseGet(Collections::emptyList);
    }

    private SpiAccountAccess getAccountDetailsFromReferences(SpiAccountConsent accountConsent) {
        SpiAccountAccess accountAccess = accountConsent.getAccess();
        this.updateAspspAccountId(accountAccess.getAccounts());
        this.updateAspspAccountId(accountAccess.getTransactions());
        if (accountConsent.isWithBalance()) {
            this.updateAspspAccountId(accountAccess.getBalances());
        }
        return accountAccess;
    }

    private void updateAspspAccountId(List<SpiAccountReference> references) {
        for (SpiAccountReference reference : references) {
            Optional spiAccountDetails = this.getAccountDetailsByAccountReference(reference);
            if (!spiAccountDetails.isPresent()) continue;
            SpiAccountDetails details = (SpiAccountDetails)spiAccountDetails.get();
            reference.setResourceId(details.getResourceId());
            reference.setAspspAccountId(details.getAspspAccountId());
        }
    }

    private Optional<SpiAccountDetails> getAccountDetailsByAccountReference(SpiAccountReference reference) {
        if (reference == null) {
            return Optional.empty();
        }
        List accountDetails = Optional.ofNullable(this.aspspRestTemplate.exchange(this.remoteSpiUrls.getAccountDetailsByIban(), HttpMethod.GET, new HttpEntity(null), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{reference.getIban()}).getBody()).orElseGet(Collections::emptyList);
        return accountDetails.stream().filter(acc -> acc.getCurrency() == reference.getCurrency()).filter(acc -> acc.getIban().equals(reference.getIban())).findFirst();
    }

    @ConstructorProperties(value={"remoteSpiUrls", "aspspRestTemplate", "keycloakInvokerService", "jsonConverter"})
    public AisConsentSpiImpl(AspspRemoteUrls remoteSpiUrls, RestTemplate aspspRestTemplate, KeycloakInvokerService keycloakInvokerService, SpiMockJsonConverter jsonConverter) {
        this.remoteSpiUrls = remoteSpiUrls;
        this.aspspRestTemplate = aspspRestTemplate;
        this.keycloakInvokerService = keycloakInvokerService;
        this.jsonConverter = jsonConverter;
    }
}

