/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.impl;

import de.adorsys.aspsp.xs2a.spi.config.rest.AspspRemoteUrls;
import de.adorsys.aspsp.xs2a.spi.impl.AccountSpiImpl;
import de.adorsys.psd2.xs2a.core.ais.BookingStatus;
import de.adorsys.psd2.xs2a.core.consent.AisConsentRequestType;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.exception.RestException;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransaction;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransactionReport;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiAccountAccess;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponseStatus;
import de.adorsys.psd2.xs2a.spi.service.AccountSpi;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class AccountSpiImpl
implements AccountSpi {
    private static final String TEST_ASPSP_DATA = "Test aspsp data";
    private final AspspRemoteUrls remoteSpiUrls;
    @Qualifier(value="aspspRestTemplate")
    private final RestTemplate aspspRestTemplate;

    public SpiResponse<List<SpiAccountDetails>> requestAccountList(@NotNull SpiContextData contextData, boolean withBalance, @NotNull SpiAccountConsent accountConsent, @NotNull AspspConsentData aspspConsentData) {
        try {
            List accountDetailsList = EnumSet.of(AisConsentRequestType.GLOBAL, AisConsentRequestType.BANK_OFFERED).contains(accountConsent.getAisConsentRequestType()) ? this.getAccountDetailsByPsuId(accountConsent) : this.getAccountDetailsFromReferences(accountConsent);
            return SpiResponse.builder().payload((Object)this.filterAccountDetailsByWithBalance(withBalance, accountDetailsList, accountConsent.getAccess())).aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    public SpiResponse<SpiAccountDetails> requestAccountDetailForAccount(@NotNull SpiContextData contextData, boolean withBalance, @NotNull SpiAccountReference accountReference, @NotNull SpiAccountConsent spiAccountConsent, @NotNull AspspConsentData aspspConsentData) {
        try {
            SpiAccountDetails accountDetails = (SpiAccountDetails)this.aspspRestTemplate.getForObject(this.remoteSpiUrls.getAccountDetailsById(), SpiAccountDetails.class, new Object[]{accountReference.getResourceId()});
            if (!withBalance) {
                accountDetails.emptyBalances();
            }
            return SpiResponse.builder().payload((Object)accountDetails).aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    public SpiResponse<SpiTransactionReport> requestTransactionsForAccount(@NotNull SpiContextData contextData, String acceptMediaType, boolean withBalance, @NotNull LocalDate dateFrom, @NotNull LocalDate dateTo, BookingStatus bookingStatus, @NotNull SpiAccountReference accountReference, @NotNull SpiAccountConsent spiAccountConsent, @NotNull AspspConsentData aspspConsentData) {
        try {
            SpiAccountDetails accountDetails = (SpiAccountDetails)this.aspspRestTemplate.getForObject(this.remoteSpiUrls.getAccountDetailsById(), SpiAccountDetails.class, new Object[]{accountReference.getResourceId()});
            HashMap<String, String> uriParams = new HashMap<String, String>();
            uriParams.put("account-id", accountReference.getResourceId());
            UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)this.remoteSpiUrls.readTransactionsByPeriod()).queryParam("dateFrom", new Object[]{dateFrom}).queryParam("dateTo", new Object[]{dateTo}).buildAndExpand(uriParams);
            List transactions = this.getFilteredTransactions(uriComponents, bookingStatus);
            List balances = null;
            if (withBalance) {
                balances = accountDetails.getBalances();
            }
            SpiResponse.SpiResponseBuilder responseBuilder = SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes()));
            if (acceptMediaType.contains("application/json")) {
                SpiTransactionReport transactionReport = new SpiTransactionReport(transactions, balances, "application/json", null);
                responseBuilder = responseBuilder.payload((Object)transactionReport);
            } else if (acceptMediaType.contains("text/plain")) {
                StringBuilder textResponseBuilder = new StringBuilder();
                int transactionsCount = transactions.size();
                textResponseBuilder.append("Transactions report in plain text format.\n").append("=========================================\n").append("Transactions count: ").append(transactionsCount).append("\n\n");
                if (transactionsCount > 0) {
                    textResponseBuilder.append("Transactions:\n");
                    for (SpiTransaction transaction : transactions) {
                        textResponseBuilder.append(transaction).append("\n");
                    }
                }
                textResponseBuilder.append("\nEnd of report.");
                SpiTransactionReport transactionReport = new SpiTransactionReport(Collections.emptyList(), Collections.emptyList(), "text/plain", textResponseBuilder.toString().getBytes(StandardCharsets.UTF_8));
                responseBuilder = responseBuilder.payload((Object)transactionReport);
            } else {
                return responseBuilder.fail(SpiResponseStatus.NOT_SUPPORTED);
            }
            return responseBuilder.success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    public SpiResponse<SpiTransaction> requestTransactionForAccountByTransactionId(@NotNull SpiContextData contextData, @NotNull String transactionId, @NotNull SpiAccountReference accountReference, @NotNull SpiAccountConsent accountConsent, @NotNull AspspConsentData aspspConsentData) {
        try {
            SpiTransaction transaction = (SpiTransaction)this.aspspRestTemplate.getForObject(this.remoteSpiUrls.readTransactionById(), SpiTransaction.class, new Object[]{transactionId, accountReference.getResourceId()});
            return SpiResponse.builder().payload((Object)transaction).aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    public SpiResponse<List<SpiAccountBalance>> requestBalancesForAccount(@NotNull SpiContextData contextData, @NotNull SpiAccountReference accountReference, @NotNull SpiAccountConsent spiAccountConsent, @NotNull AspspConsentData aspspConsentData) {
        try {
            List accountBalances = (List)this.aspspRestTemplate.exchange(this.remoteSpiUrls.getBalancesByAccountId(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{accountReference.getResourceId()}).getBody();
            return SpiResponse.builder().payload((Object)accountBalances).aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    private List<SpiTransaction> getFilteredTransactions(UriComponents uriComponents, BookingStatus bookingStatus) {
        return Optional.ofNullable(this.getTransactionsFromAspsp(uriComponents)).map(t -> this.filterByBookingStatus(t, bookingStatus)).orElse(Collections.emptyList());
    }

    private List<SpiTransaction> getTransactionsFromAspsp(UriComponents uriComponents) {
        return (List)this.aspspRestTemplate.exchange(uriComponents.toUriString(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]).getBody();
    }

    private List<SpiTransaction> filterByBookingStatus(List<SpiTransaction> transactionList, BookingStatus bookingStatus) {
        switch (5.$SwitchMap$de$adorsys$psd2$xs2a$core$ais$BookingStatus[bookingStatus.ordinal()]) {
            case 1: {
                return transactionList.stream().filter(SpiTransaction::isBookedTransaction).collect(Collectors.toList());
            }
            case 2: {
                return transactionList.stream().filter(SpiTransaction::isPendingTransaction).collect(Collectors.toList());
            }
        }
        return transactionList;
    }

    private List<SpiAccountDetails> getAccountDetailsByPsuId(SpiAccountConsent accountConsent) {
        String psuId = CollectionUtils.isNotEmpty((Collection)accountConsent.getPsuData()) ? ((SpiPsuData)accountConsent.getPsuData().get(0)).getPsuId() : null;
        return Optional.ofNullable(this.aspspRestTemplate.exchange(this.remoteSpiUrls.getAccountDetailsByPsuId(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{psuId}).getBody()).orElseGet(Collections::emptyList);
    }

    private List<SpiAccountDetails> getAccountDetailsFromReferences(SpiAccountConsent accountConsent) {
        SpiAccountAccess accountAccess = accountConsent.getAccess();
        return this.getAccountDetailsFromReferences(accountAccess.getAccounts());
    }

    private List<SpiAccountDetails> getAccountDetailsFromReferences(List<SpiAccountReference> references) {
        if (CollectionUtils.isEmpty(references)) {
            return Collections.emptyList();
        }
        return references.stream().map(arg_0 -> this.getAccountDetailsByAccountReference(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<SpiAccountDetails> getAccountDetailsByAccountReference(SpiAccountReference reference) {
        if (reference == null) {
            return Optional.empty();
        }
        List accountDetails = Optional.ofNullable(this.aspspRestTemplate.exchange(this.remoteSpiUrls.getAccountDetailsByIban(), HttpMethod.GET, new HttpEntity(null), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{reference.getIban()}).getBody()).orElseGet(Collections::emptyList);
        return accountDetails.stream().filter(acc -> acc.getResourceId().equals(reference.getResourceId())).findFirst();
    }

    private List<SpiAccountDetails> filterAccountDetailsByWithBalance(boolean withBalance, List<SpiAccountDetails> details, SpiAccountAccess spiAccountAccess) {
        List balanceReferences = spiAccountAccess.getBalances();
        for (SpiAccountDetails spiAccountDetails : details) {
            if (withBalance && this.isValidAccountByAccess(spiAccountDetails.getResourceId(), balanceReferences)) continue;
            spiAccountDetails.emptyBalances();
        }
        return details;
    }

    private boolean isValidAccountByAccess(String accountId, List<SpiAccountReference> allowedAccountData) {
        return CollectionUtils.isNotEmpty(allowedAccountData) && allowedAccountData.stream().anyMatch(a -> accountId.equals(a.getResourceId()));
    }

    @ConstructorProperties(value={"remoteSpiUrls", "aspspRestTemplate"})
    public AccountSpiImpl(AspspRemoteUrls remoteSpiUrls, RestTemplate aspspRestTemplate) {
        this.remoteSpiUrls = remoteSpiUrls;
        this.aspspRestTemplate = aspspRestTemplate;
    }
}

