/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.rest.client;

import de.adorsys.aspsp.xs2a.spi.config.rest.AspspRemoteUrls;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransaction;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class AccountRestClient {
    private final AspspRemoteUrls remoteSpiUrls;
    @Qualifier(value="aspspRestTemplate")
    private final RestTemplate aspspRestTemplate;

    public SpiAccountDetails getAccountDetailsById(String resourceId) {
        return (SpiAccountDetails)this.aspspRestTemplate.getForObject(this.remoteSpiUrls.getAccountDetailsById(), SpiAccountDetails.class, new Object[]{resourceId});
    }

    public List<SpiAccountDetails> getAccountDetailsByPsuId(String psuId) {
        return (List)this.aspspRestTemplate.exchange(this.remoteSpiUrls.getAccountDetailsByPsuId(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{psuId}).getBody();
    }

    public List<SpiAccountDetails> getAccountDetailsByIban(String iban) {
        return (List)this.aspspRestTemplate.exchange(this.remoteSpiUrls.getAccountDetailsByIban(), HttpMethod.GET, new HttpEntity(null), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{iban}).getBody();
    }

    public SpiTransaction getTransactionByIdAndResourceId(String transactionId, String resourceId) {
        return (SpiTransaction)this.aspspRestTemplate.getForObject(this.remoteSpiUrls.readTransactionById(), SpiTransaction.class, new Object[]{transactionId, resourceId});
    }

    public List<SpiTransaction> getTransactionsByResourceIdAndPeriod(String resourceId, LocalDate dateFrom, LocalDate dateTo) {
        return (List)this.aspspRestTemplate.exchange(this.remoteSpiUrls.readTransactionsByPeriod(resourceId, dateFrom, dateTo), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]).getBody();
    }

    public List<SpiAccountBalance> getBalancesByResourceId(String resourceId) {
        return (List)this.aspspRestTemplate.exchange(this.remoteSpiUrls.getBalancesByAccountId(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{resourceId}).getBody();
    }

    @ConstructorProperties(value={"remoteSpiUrls", "aspspRestTemplate"})
    public AccountRestClient(AspspRemoteUrls remoteSpiUrls, RestTemplate aspspRestTemplate) {
        this.remoteSpiUrls = remoteSpiUrls;
        this.aspspRestTemplate = aspspRestTemplate;
    }
}

