/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.mapper;

import de.adorsys.aspsp.xs2a.spi.mapper.SpiPaymentMapper;
import de.adorsys.aspsp.xs2a.spi.mapper.SpiRemittanceMapper;
import de.adorsys.psd2.aspsp.mock.api.account.AspspAccountReference;
import de.adorsys.psd2.aspsp.mock.api.payment.AspspSinglePayment;
import de.adorsys.psd2.xs2a.core.pis.PurposeCode;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiSinglePaymentInitiationResponse;
import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class SpiSinglePaymentMapper {
    private final SpiPaymentMapper spiPaymentMapper;
    private final SpiRemittanceMapper spiRemittanceMapper;

    public AspspSinglePayment mapToAspspSinglePayment(@NotNull SpiSinglePayment payment, TransactionStatus transactionStatus) {
        AspspSinglePayment single = new AspspSinglePayment();
        single.setPaymentId(payment.getPaymentId());
        single.setEndToEndIdentification(payment.getEndToEndIdentification());
        single.setDebtorAccount(this.spiPaymentMapper.mapToAspspAccountReference(payment.getDebtorAccount()));
        single.setInstructedAmount(this.spiPaymentMapper.mapToAspspAmount(payment.getInstructedAmount()));
        single.setCreditorAccount(this.spiPaymentMapper.mapToAspspAccountReference(payment.getCreditorAccount()));
        single.setCreditorAgent(payment.getCreditorAgent());
        single.setCreditorName(payment.getCreditorName());
        single.setCreditorAddress(this.spiPaymentMapper.mapToAspspAddress(payment.getCreditorAddress()));
        single.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        single.setPaymentStatus(this.spiPaymentMapper.mapToAspspTransactionStatus(transactionStatus));
        single.setRequestedExecutionTime((LocalDateTime)Optional.ofNullable(payment.getRequestedExecutionTime()).map(OffsetDateTime::toLocalDateTime).orElse(null));
        single.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        single.setUltimateDebtor(payment.getUltimateDebtor());
        single.setUltimateCreditor(payment.getUltimateCreditor());
        single.setPurposeCode((String)Optional.ofNullable(payment.getPurposeCode()).map(PurposeCode::toString).orElse(null));
        single.setRemittanceInformationStructured(this.spiRemittanceMapper.mapToAspspRemittance(payment.getRemittanceInformationStructured()));
        return single;
    }

    public SpiSinglePayment mapToSpiSinglePayment(@NotNull AspspSinglePayment payment, String paymentProduct) {
        SpiSinglePayment single = new SpiSinglePayment(paymentProduct);
        single.setPaymentId(payment.getPaymentId());
        single.setEndToEndIdentification(payment.getEndToEndIdentification());
        single.setDebtorAccount(this.spiPaymentMapper.mapToSpiAccountReference(payment.getDebtorAccount()));
        single.setInstructedAmount(this.spiPaymentMapper.mapToSpiAmount(payment.getInstructedAmount()));
        single.setCreditorAccount(this.spiPaymentMapper.mapToSpiAccountReference(payment.getCreditorAccount()));
        single.setCreditorAgent(payment.getCreditorAgent());
        single.setCreditorName(payment.getCreditorName());
        single.setCreditorAddress(this.spiPaymentMapper.mapToSpiAddress(payment.getCreditorAddress()));
        single.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        single.setPaymentStatus(this.spiPaymentMapper.mapToTransactionStatus(payment.getPaymentStatus()));
        single.setRequestedExecutionTime((OffsetDateTime)Optional.ofNullable(payment.getRequestedExecutionTime()).map(t -> t.atOffset(ZoneOffset.UTC)).orElse(null));
        single.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        single.setUltimateDebtor(payment.getUltimateDebtor());
        single.setUltimateCreditor(payment.getUltimateCreditor());
        single.setPurposeCode(PurposeCode.fromValue((String)payment.getPurposeCode()));
        single.setRemittanceInformationStructured(this.spiRemittanceMapper.mapToSpiRemittance(payment.getRemittanceInformationStructured()));
        return single;
    }

    public SpiSinglePaymentInitiationResponse mapToSpiSinglePaymentResponse(@NotNull AspspSinglePayment payment) {
        SpiSinglePaymentInitiationResponse spi = new SpiSinglePaymentInitiationResponse();
        spi.setAspspAccountId((String)Optional.ofNullable(payment.getDebtorAccount()).map(AspspAccountReference::getAccountId).orElse(null));
        spi.setPaymentId(payment.getPaymentId());
        spi.setMultilevelScaRequired(CollectionUtils.size((Object)payment.getPsuDataList()) > 1);
        if (payment.getPaymentId() == null) {
            spi.setTransactionStatus(TransactionStatus.RJCT);
        } else {
            spi.setTransactionStatus(TransactionStatus.RCVD);
        }
        return spi;
    }

    @ConstructorProperties(value={"spiPaymentMapper", "spiRemittanceMapper"})
    public SpiSinglePaymentMapper(SpiPaymentMapper spiPaymentMapper, SpiRemittanceMapper spiRemittanceMapper) {
        this.spiPaymentMapper = spiPaymentMapper;
        this.spiRemittanceMapper = spiRemittanceMapper;
    }
}

