/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.mapper;

import de.adorsys.psd2.aspsp.mock.api.account.AspspAccountReference;
import de.adorsys.psd2.aspsp.mock.api.common.AspspAmount;
import de.adorsys.psd2.aspsp.mock.api.common.AspspTransactionStatus;
import de.adorsys.psd2.aspsp.mock.api.payment.AspspAddress;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiAmount;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiAddress;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
public class SpiPaymentMapper {
    @Nullable
    AspspTransactionStatus mapToAspspTransactionStatus(TransactionStatus transactionStatus) {
        return Optional.ofNullable(transactionStatus).map(t -> AspspTransactionStatus.valueOf((String)t.name())).orElse(null);
    }

    @Nullable
    public TransactionStatus mapToTransactionStatus(AspspTransactionStatus aspspTransactionStatus) {
        return Optional.ofNullable(aspspTransactionStatus).map(t -> TransactionStatus.valueOf((String)t.name())).orElse(null);
    }

    AspspAmount mapToAspspAmount(@NotNull SpiAmount spiAmount) {
        return new AspspAmount(spiAmount.getCurrency(), spiAmount.getAmount());
    }

    @Nullable
    AspspAddress mapToAspspAddress(SpiAddress spiAddress) {
        return Optional.ofNullable(spiAddress).map(s -> new AspspAddress(s.getStreet(), s.getBuildingNumber(), s.getCity(), s.getPostalCode(), s.getCountry())).orElse(null);
    }

    AspspAccountReference mapToAspspAccountReference(@NotNull SpiAccountReference spiAccountReference) {
        return new AspspAccountReference(spiAccountReference.getResourceId(), spiAccountReference.getIban(), spiAccountReference.getBban(), spiAccountReference.getPan(), spiAccountReference.getMaskedPan(), spiAccountReference.getMsisdn(), spiAccountReference.getCurrency());
    }

    SpiAccountReference mapToSpiAccountReference(@NotNull AspspAccountReference aspspAccountReference) {
        return new SpiAccountReference(aspspAccountReference.getAccountId(), aspspAccountReference.getIban(), aspspAccountReference.getBban(), aspspAccountReference.getPan(), aspspAccountReference.getMaskedPan(), aspspAccountReference.getMsisdn(), aspspAccountReference.getCurrency());
    }

    SpiAmount mapToSpiAmount(@NotNull AspspAmount aspspAmount) {
        return new SpiAmount(aspspAmount.getCurrency(), aspspAmount.getAmount());
    }

    @Nullable
    SpiAddress mapToSpiAddress(AspspAddress aspspAddress) {
        return Optional.ofNullable(aspspAddress).map(a -> new SpiAddress(a.getStreet(), a.getBuildingNumber(), a.getCity(), a.getPostalCode(), a.getCountry())).orElse(null);
    }
}

