/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.impl;

import de.adorsys.aspsp.xs2a.spi.impl.AccountSpiImpl;
import de.adorsys.aspsp.xs2a.spi.rest.client.AccountRestClient;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.ais.BookingStatus;
import de.adorsys.psd2.xs2a.core.consent.AisConsentRequestType;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.exception.RestException;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransaction;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransactionReport;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiAccountAccess;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponseStatus;
import de.adorsys.psd2.xs2a.spi.service.AccountSpi;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class AccountSpiImpl
implements AccountSpi {
    private static final String TEST_ASPSP_DATA = "Test aspsp data";
    private static final String DEFAULT_ACCEPT_MEDIA_TYPE = "application/json";
    private static final String WILDCARD_ACCEPT_HEADER = "*/*";
    private final AccountRestClient accountRestClient;

    public SpiResponse<List<SpiAccountDetails>> requestAccountList(@NotNull SpiContextData contextData, boolean withBalance, @NotNull SpiAccountConsent accountConsent, @NotNull AspspConsentData aspspConsentData) {
        try {
            List accountDetailsList = EnumSet.of(AisConsentRequestType.GLOBAL, AisConsentRequestType.BANK_OFFERED, AisConsentRequestType.ALL_AVAILABLE_ACCOUNTS).contains(accountConsent.getAisConsentRequestType()) ? this.getAccountDetailsByPsuId(accountConsent) : this.getAccountDetailsFromReferences(accountConsent);
            return SpiResponse.builder().payload((Object)this.filterAccountDetailsByWithBalance(withBalance, accountDetailsList, accountConsent.getAccess())).aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    public SpiResponse<SpiAccountDetails> requestAccountDetailForAccount(@NotNull SpiContextData contextData, boolean withBalance, @NotNull SpiAccountReference accountReference, @NotNull SpiAccountConsent spiAccountConsent, @NotNull AspspConsentData aspspConsentData) {
        try {
            SpiAccountDetails accountDetails = this.accountRestClient.getAccountDetailsById(accountReference.getResourceId());
            if (!withBalance) {
                accountDetails.emptyBalances();
            }
            return SpiResponse.builder().payload((Object)accountDetails).aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    public SpiResponse<SpiTransactionReport> requestTransactionsForAccount(@NotNull SpiContextData contextData, String acceptMediaType, boolean withBalance, @NotNull LocalDate dateFrom, @NotNull LocalDate dateTo, BookingStatus bookingStatus, @NotNull SpiAccountReference accountReference, @NotNull SpiAccountConsent spiAccountConsent, @NotNull AspspConsentData aspspConsentData) {
        try {
            SpiAccountDetails accountDetails = this.accountRestClient.getAccountDetailsById(accountReference.getResourceId());
            List transactions = this.getFilteredTransactions(accountReference.getResourceId(), dateFrom, dateTo, bookingStatus);
            List balances = this.getBalances(withBalance, accountDetails);
            SpiResponse.SpiResponseBuilder responseBuilder = SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes()));
            String responseMediaType = this.processAcceptMediaType(acceptMediaType);
            if (responseMediaType.contains(DEFAULT_ACCEPT_MEDIA_TYPE)) {
                SpiTransactionReport transactionReport = new SpiTransactionReport(transactions, balances, DEFAULT_ACCEPT_MEDIA_TYPE, null);
                responseBuilder = responseBuilder.payload((Object)transactionReport);
            } else if (responseMediaType.contains("text/plain")) {
                StringBuilder textResponseBuilder = new StringBuilder();
                int transactionsCount = transactions.size();
                textResponseBuilder.append("Transactions report in plain text format.\n").append("=========================================\n").append("Transactions count: ").append(transactionsCount).append("\n\n");
                if (transactionsCount > 0) {
                    textResponseBuilder.append("Transactions:\n");
                    for (SpiTransaction transaction : transactions) {
                        textResponseBuilder.append(transaction).append("\n");
                    }
                }
                textResponseBuilder.append("\nEnd of report.");
                SpiTransactionReport transactionReport = new SpiTransactionReport(Collections.emptyList(), Collections.emptyList(), "text/plain", textResponseBuilder.toString().getBytes(StandardCharsets.UTF_8));
                responseBuilder = responseBuilder.payload((Object)transactionReport);
            } else {
                return responseBuilder.fail(SpiResponseStatus.NOT_SUPPORTED);
            }
            return responseBuilder.success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    private String processAcceptMediaType(String acceptMediaType) {
        return StringUtils.isBlank((CharSequence)acceptMediaType) || WILDCARD_ACCEPT_HEADER.equals(acceptMediaType) ? DEFAULT_ACCEPT_MEDIA_TYPE : acceptMediaType;
    }

    private List<SpiAccountBalance> getBalances(boolean withBalance, SpiAccountDetails accountDetails) {
        if (withBalance) {
            return accountDetails.getBalances();
        }
        return null;
    }

    public SpiResponse<SpiTransaction> requestTransactionForAccountByTransactionId(@NotNull SpiContextData contextData, @NotNull String transactionId, @NotNull SpiAccountReference accountReference, @NotNull SpiAccountConsent accountConsent, @NotNull AspspConsentData aspspConsentData) {
        try {
            SpiTransaction transaction = this.accountRestClient.getTransactionByIdAndResourceId(transactionId, accountReference.getResourceId());
            return SpiResponse.builder().payload((Object)transaction).aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    public SpiResponse<List<SpiAccountBalance>> requestBalancesForAccount(@NotNull SpiContextData contextData, @NotNull SpiAccountReference accountReference, @NotNull SpiAccountConsent spiAccountConsent, @NotNull AspspConsentData aspspConsentData) {
        try {
            List accountBalances = this.accountRestClient.getBalancesByResourceId(accountReference.getResourceId());
            return SpiResponse.builder().payload((Object)accountBalances).aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    private List<SpiTransaction> getFilteredTransactions(String resourceId, LocalDate dateFrom, LocalDate dateTo, BookingStatus bookingStatus) {
        return Optional.ofNullable(this.accountRestClient.getTransactionsByResourceIdAndPeriod(resourceId, dateFrom, dateTo)).map(t -> this.filterByBookingStatus(t, bookingStatus)).orElse(Collections.emptyList());
    }

    private List<SpiTransaction> filterByBookingStatus(List<SpiTransaction> transactionList, BookingStatus bookingStatus) {
        switch (1.$SwitchMap$de$adorsys$psd2$xs2a$core$ais$BookingStatus[bookingStatus.ordinal()]) {
            case 1: {
                return transactionList.stream().filter(SpiTransaction::isBookedTransaction).collect(Collectors.toList());
            }
            case 2: {
                return transactionList.stream().filter(SpiTransaction::isPendingTransaction).collect(Collectors.toList());
            }
        }
        return transactionList;
    }

    private List<SpiAccountDetails> getAccountDetailsByPsuId(SpiAccountConsent accountConsent) {
        String psuId = CollectionUtils.isNotEmpty((Collection)accountConsent.getPsuData()) ? ((SpiPsuData)accountConsent.getPsuData().get(0)).getPsuId() : null;
        ArrayList<SpiAccountDetails> spiAccountDetails = new ArrayList<SpiAccountDetails>();
        List spiAccountDetailsByPsuId = Optional.ofNullable(this.accountRestClient.getAccountDetailsByPsuId(psuId)).orElseGet(Collections::emptyList);
        spiAccountDetailsByPsuId.forEach(a -> spiAccountDetails.add(this.accountRestClient.getAccountDetailsById(a.getResourceId())));
        return spiAccountDetails;
    }

    private List<SpiAccountDetails> getAccountDetailsFromReferences(SpiAccountConsent accountConsent) {
        SpiAccountAccess accountAccess = accountConsent.getAccess();
        return this.getAccountDetailsFromReferences(accountAccess.getAccounts());
    }

    private List<SpiAccountDetails> getAccountDetailsFromReferences(List<SpiAccountReference> references) {
        if (CollectionUtils.isEmpty(references)) {
            return Collections.emptyList();
        }
        return references.stream().map(arg_0 -> this.getAccountDetailsByAccountReference(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<SpiAccountDetails> getAccountDetailsByAccountReference(SpiAccountReference reference) {
        if (reference == null) {
            return Optional.empty();
        }
        List accountDetails = Optional.ofNullable(this.accountRestClient.getAccountDetailsByIban(reference.getIban())).orElseGet(Collections::emptyList);
        return accountDetails.stream().filter(acc -> acc.getResourceId().equals(reference.getResourceId())).findFirst();
    }

    private List<SpiAccountDetails> filterAccountDetailsByWithBalance(boolean withBalance, List<SpiAccountDetails> details, SpiAccountAccess spiAccountAccess) {
        if (withBalance && this.isConsentSupportedBalances(spiAccountAccess)) {
            return details;
        }
        List balanceReferences = spiAccountAccess.getBalances();
        for (SpiAccountDetails spiAccountDetails : details) {
            if (withBalance && this.isValidAccountByAccess(spiAccountDetails.getResourceId(), balanceReferences)) continue;
            spiAccountDetails.emptyBalances();
        }
        return details;
    }

    private boolean isConsentSupportedBalances(SpiAccountAccess spiAccountAccess) {
        boolean isConsentGlobal = spiAccountAccess.getAllPsd2() != null;
        boolean isConsentForAvailableAccountsWithBalances = spiAccountAccess.getAvailableAccountsWithBalances() == AccountAccessType.ALL_ACCOUNTS;
        return isConsentGlobal || isConsentForAvailableAccountsWithBalances;
    }

    private boolean isValidAccountByAccess(String accountId, List<SpiAccountReference> allowedAccountData) {
        return CollectionUtils.isNotEmpty(allowedAccountData) && allowedAccountData.stream().anyMatch(a -> accountId.equals(a.getResourceId()));
    }

    @ConstructorProperties(value={"accountRestClient"})
    public AccountSpiImpl(AccountRestClient accountRestClient) {
        this.accountRestClient = accountRestClient;
    }
}

