/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.mapper;

import de.adorsys.aspsp.xs2a.spi.mapper.SpiPaymentMapper;
import de.adorsys.psd2.aspsp.mock.api.account.AspspAccountReference;
import de.adorsys.psd2.aspsp.mock.api.payment.AspspDayOfExecution;
import de.adorsys.psd2.aspsp.mock.api.payment.AspspExecutionRule;
import de.adorsys.psd2.aspsp.mock.api.payment.AspspPeriodicPayment;
import de.adorsys.psd2.xs2a.core.pis.PisDayOfExecution;
import de.adorsys.psd2.xs2a.core.pis.PisExecutionRule;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.code.SpiFrequencyCode;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPeriodicPaymentInitiationResponse;
import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class SpiPeriodicPaymentMapper {
    private final SpiPaymentMapper spiPaymentMapper;

    public AspspPeriodicPayment mapToAspspPeriodicPayment(@NotNull SpiPeriodicPayment payment, TransactionStatus transactionStatus) {
        AspspPeriodicPayment periodic = new AspspPeriodicPayment();
        periodic.setPaymentId(payment.getPaymentId());
        periodic.setEndToEndIdentification(payment.getEndToEndIdentification());
        periodic.setDebtorAccount(this.spiPaymentMapper.mapToAspspAccountReference(payment.getDebtorAccount()));
        periodic.setInstructedAmount(this.spiPaymentMapper.mapToAspspAmount(payment.getInstructedAmount()));
        periodic.setCreditorAccount(this.spiPaymentMapper.mapToAspspAccountReference(payment.getCreditorAccount()));
        periodic.setCreditorAgent(payment.getCreditorAgent());
        periodic.setCreditorName(payment.getCreditorName());
        periodic.setCreditorAddress(this.spiPaymentMapper.mapToAspspAddress(payment.getCreditorAddress()));
        periodic.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        periodic.setPaymentStatus(this.spiPaymentMapper.mapToAspspTransactionStatus(transactionStatus));
        periodic.setStartDate(payment.getStartDate());
        periodic.setEndDate(payment.getEndDate());
        periodic.setExecutionRule((AspspExecutionRule)this.mapToAspspExecutionRule(payment.getExecutionRule()).orElse(null));
        periodic.setFrequency(payment.getFrequency().name());
        periodic.setDayOfExecution((AspspDayOfExecution)this.mapToAspspDayOfExecution(payment.getDayOfExecution()).orElse(null));
        periodic.setRequestedExecutionTime((LocalDateTime)Optional.ofNullable(payment.getRequestedExecutionTime()).map(OffsetDateTime::toLocalDateTime).orElse(null));
        periodic.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        return periodic;
    }

    public SpiPeriodicPayment mapToSpiPeriodicPayment(@NotNull AspspPeriodicPayment payment, String paymentProduct) {
        SpiPeriodicPayment periodic = new SpiPeriodicPayment(paymentProduct);
        periodic.setPaymentId(payment.getPaymentId());
        periodic.setEndToEndIdentification(payment.getEndToEndIdentification());
        periodic.setDebtorAccount(this.spiPaymentMapper.mapToSpiAccountReference(payment.getDebtorAccount()));
        periodic.setInstructedAmount(this.spiPaymentMapper.mapToSpiAmount(payment.getInstructedAmount()));
        periodic.setCreditorAccount(this.spiPaymentMapper.mapToSpiAccountReference(payment.getCreditorAccount()));
        periodic.setCreditorAgent(payment.getCreditorAgent());
        periodic.setCreditorName(payment.getCreditorName());
        periodic.setCreditorAddress(this.spiPaymentMapper.mapToSpiAddress(payment.getCreditorAddress()));
        periodic.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        periodic.setPaymentStatus(this.spiPaymentMapper.mapToTransactionStatus(payment.getPaymentStatus()));
        periodic.setStartDate(payment.getStartDate());
        periodic.setEndDate(payment.getEndDate());
        periodic.setExecutionRule((PisExecutionRule)this.mapToPisExecutionRule(payment.getExecutionRule()).orElse(null));
        periodic.setFrequency(SpiFrequencyCode.valueOf((String)payment.getFrequency()));
        periodic.setDayOfExecution((PisDayOfExecution)this.mapToPisDayOfExecution(payment.getDayOfExecution()).orElse(null));
        periodic.setRequestedExecutionTime((OffsetDateTime)Optional.ofNullable(payment.getRequestedExecutionTime()).map(t -> t.atOffset(ZoneOffset.UTC)).orElse(null));
        periodic.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        return periodic;
    }

    public SpiPeriodicPaymentInitiationResponse mapToSpiPeriodicPaymentResponse(@NotNull AspspPeriodicPayment payment) {
        SpiPeriodicPaymentInitiationResponse spi = new SpiPeriodicPaymentInitiationResponse();
        spi.setAspspAccountId((String)Optional.ofNullable(payment.getDebtorAccount()).map(AspspAccountReference::getAccountId).orElse(null));
        spi.setPaymentId(payment.getPaymentId());
        spi.setMultilevelScaRequired(CollectionUtils.size((Object)payment.getPsuDataList()) > 1);
        if (payment.getPaymentId() == null) {
            spi.setTransactionStatus(TransactionStatus.RJCT);
        } else {
            spi.setTransactionStatus(TransactionStatus.RCVD);
        }
        return spi;
    }

    private Optional<PisDayOfExecution> mapToPisDayOfExecution(AspspDayOfExecution dayOfExecution) {
        return Optional.ofNullable(dayOfExecution).map(AspspDayOfExecution::toString).flatMap(PisDayOfExecution::getByValue);
    }

    private Optional<PisExecutionRule> mapToPisExecutionRule(AspspExecutionRule rule) {
        return Optional.ofNullable(rule).map(AspspExecutionRule::toString).flatMap(PisExecutionRule::getByValue);
    }

    private Optional<AspspDayOfExecution> mapToAspspDayOfExecution(PisDayOfExecution dayOfExecution) {
        return Optional.ofNullable(dayOfExecution).map(PisDayOfExecution::toString).flatMap(AspspDayOfExecution::getByValue);
    }

    private Optional<AspspExecutionRule> mapToAspspExecutionRule(PisExecutionRule rule) {
        return Optional.ofNullable(rule).map(PisExecutionRule::toString).flatMap(AspspExecutionRule::getByValue);
    }

    @ConstructorProperties(value={"spiPaymentMapper"})
    public SpiPeriodicPaymentMapper(SpiPaymentMapper spiPaymentMapper) {
        this.spiPaymentMapper = spiPaymentMapper;
    }
}

