/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.impl.service;

import de.adorsys.aspsp.xs2a.spi.config.keycloak.BearerToken;
import de.adorsys.aspsp.xs2a.spi.config.keycloak.KeycloakConfigProperties;
import de.adorsys.aspsp.xs2a.spi.domain.SpiAspspAuthorisationData;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.annotation.RequestScope;

@Service
public class KeycloakInvokerService {
    @Qualifier(value="keycloakRestTemplate")
    private final RestTemplate keycloakRestTemplate;
    private final KeycloakConfigProperties keycloakConfig;
    @Value(value="${keycloak-username}")
    private String keycloakUsername;
    @Value(value="${keycloak-password}")
    private String keycloakPassword;

    @Bean
    @RequestScope
    public BearerToken getBearerToken() {
        return new BearerToken(this.getAccessToken());
    }

    private String getAccessToken() {
        return this.obtainAuthorisationData().map(SpiAspspAuthorisationData::getAccessToken).map(t -> "Authorization: Bearer " + t).orElseThrow(IllegalArgumentException::new);
    }

    private Optional<SpiAspspAuthorisationData> obtainAuthorisationData() {
        return this.doObtainAccessToken(this.keycloakUsername, this.keycloakPassword);
    }

    public Optional<SpiAspspAuthorisationData> obtainAuthorisationData(String psuId, String password) {
        return this.doObtainAccessToken(psuId, password);
    }

    private Optional<SpiAspspAuthorisationData> doObtainAccessToken(String psuId, String password) {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"grant_type", (Object)"password");
        params.add((Object)"client_id", (Object)this.keycloakConfig.getResource());
        params.add((Object)"client_secret", (Object)this.keycloakConfig.getCredentials().getSecret());
        params.add((Object)"username", (Object)psuId);
        params.add((Object)"password", (Object)password);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        ResponseEntity response = this.keycloakRestTemplate.exchange(this.keycloakConfig.getRootPath() + "/protocol/openid-connect/token", HttpMethod.POST, new HttpEntity((Object)params, (MultiValueMap)headers), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            return Optional.empty();
        }
        return Optional.ofNullable(response.getBody()).filter(body -> StringUtils.isNotBlank((CharSequence)((CharSequence)body.get("access_token"))) || StringUtils.isNotBlank((CharSequence)((CharSequence)body.get("refresh_token")))).map(body -> new SpiAspspAuthorisationData(psuId, password, (String)body.get("access_token"), (String)body.get("refresh_token")));
    }

    @ConstructorProperties(value={"keycloakRestTemplate", "keycloakConfig"})
    public KeycloakInvokerService(RestTemplate keycloakRestTemplate, KeycloakConfigProperties keycloakConfig) {
        this.keycloakRestTemplate = keycloakRestTemplate;
        this.keycloakConfig = keycloakConfig;
    }
}

