/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.mapper;

import de.adorsys.aspsp.xs2a.spi.mapper.SpiPaymentMapper;
import de.adorsys.psd2.aspsp.mock.api.payment.AspspPaymentInfo;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPaymentInfo;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiCommonPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentInitiationResponse;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class SpiPaymentInfoMapper {
    private final SpiPaymentMapper spiPaymentMapper;

    public AspspPaymentInfo mapToAspspPayment(@NotNull SpiPaymentInfo payment, TransactionStatus transactionStatus) {
        AspspPaymentInfo info = new AspspPaymentInfo();
        info.setPaymentId(payment.getPaymentId());
        info.setPaymentStatus(this.spiPaymentMapper.mapToAspspTransactionStatus(transactionStatus));
        info.setPaymentProduct(payment.getPaymentProduct());
        info.setPisPaymentType(payment.getPaymentType().name());
        info.setPaymentData(payment.getPaymentData());
        return info;
    }

    public SpiPaymentInfo mapToSpiPaymentInfo(@NotNull AspspPaymentInfo payment) {
        SpiPaymentInfo spiPayment = new SpiPaymentInfo(payment.getPaymentProduct());
        spiPayment.setPaymentId(payment.getPaymentId());
        spiPayment.setPaymentType(PaymentType.valueOf((String)payment.getPisPaymentType()));
        spiPayment.setStatus(TransactionStatus.getByValue((String)payment.getPaymentStatus().getName()));
        spiPayment.setPaymentData(payment.getPaymentData());
        return spiPayment;
    }

    public SpiPaymentInitiationResponse mapToSpiPaymentInitiationResponse(@NotNull AspspPaymentInfo payment) {
        SpiCommonPaymentInitiationResponse spi = new SpiCommonPaymentInitiationResponse();
        spi.setPaymentId(payment.getPaymentId());
        spi.setMultilevelScaRequired(false);
        spi.setAspspAccountId(payment.getAspspAccountId());
        if (payment.getPaymentId() == null) {
            spi.setTransactionStatus(TransactionStatus.RJCT);
        } else {
            spi.setTransactionStatus(TransactionStatus.RCVD);
        }
        return spi;
    }

    @ConstructorProperties(value={"spiPaymentMapper"})
    public SpiPaymentInfoMapper(SpiPaymentMapper spiPaymentMapper) {
        this.spiPaymentMapper = spiPaymentMapper;
    }
}

