/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import de.adorsys.aspsp.xs2a.spi.config.rest.AspspRemoteUrls;
import de.adorsys.aspsp.xs2a.spi.mapper.SpiBulkPaymentMapper;
import de.adorsys.aspsp.xs2a.spi.mapper.SpiPaymentMapper;
import de.adorsys.psd2.aspsp.mock.api.common.AspspTransactionStatus;
import de.adorsys.psd2.aspsp.mock.api.payment.AspspBulkPayment;
import de.adorsys.psd2.aspsp.mock.api.psu.AspspPsuData;
import de.adorsys.psd2.xs2a.component.JsonConverter;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.exception.RestException;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaConfirmation;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiBulkPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentExecutionResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponseStatus;
import de.adorsys.psd2.xs2a.spi.service.BulkPaymentSpi;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class BulkPaymentSpiImpl
implements BulkPaymentSpi {
    private static final String TEST_ASPSP_DATA = "Test aspsp data";
    @Qualifier(value="aspspRestTemplate")
    private final RestTemplate aspspRestTemplate;
    private final AspspRemoteUrls aspspRemoteUrls;
    private final SpiPaymentMapper spiPaymentMapper;
    private final SpiBulkPaymentMapper spiBulkPaymentMapper;
    private final JsonConverter jsonConverter;

    @NotNull
    public SpiResponse<SpiBulkPaymentInitiationResponse> initiatePayment(@NotNull SpiContextData spiContextData, @NotNull SpiBulkPayment payment, @NotNull AspspConsentData initialAspspConsentData) {
        try {
            AspspBulkPayment request = this.spiBulkPaymentMapper.mapToAspspBulkPayment(payment, TransactionStatus.RCVD);
            ResponseEntity aspspResponse = this.aspspRestTemplate.postForEntity(this.aspspRemoteUrls.createBulkPayment(), (Object)request, AspspBulkPayment.class, new Object[0]);
            SpiBulkPaymentInitiationResponse response = this.spiBulkPaymentMapper.mapToSpiBulkPaymentResponse((AspspBulkPayment)aspspResponse.getBody(), payment.getPaymentProduct());
            AspspConsentData resultAspspData = initialAspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes());
            List psuDataList = ((AspspBulkPayment)aspspResponse.getBody()).getPsuDataList();
            if (CollectionUtils.size((Object)psuDataList) > 1) {
                Map authMap = psuDataList.stream().map(AspspPsuData::getPsuId).collect(Collectors.toMap(Function.identity(), id -> false));
                byte[] bytes = this.jsonConverter.toJson(authMap).map(String::getBytes).orElse(TEST_ASPSP_DATA.getBytes());
                resultAspspData = initialAspspConsentData.respondWith(bytes);
            }
            return SpiResponse.builder().aspspConsentData(resultAspspData).payload((Object)response).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(initialAspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(initialAspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @NotNull
    public SpiResponse<SpiBulkPayment> getPaymentById(@NotNull SpiContextData spiContextData, @NotNull SpiBulkPayment payment, @NotNull AspspConsentData aspspConsentData) {
        try {
            ResponseEntity aspspResponse = this.aspspRestTemplate.exchange(this.aspspRemoteUrls.getPaymentById(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{payment.getPaymentType().getValue(), payment.getPaymentProduct(), payment.getPaymentId()});
            List payments = (List)aspspResponse.getBody();
            SpiBulkPayment spiBulkPayment = this.spiBulkPaymentMapper.mapToSpiBulkPayment(payments, payment.getPaymentProduct());
            return SpiResponse.builder().aspspConsentData(aspspConsentData).payload((Object)spiBulkPayment).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(aspspConsentData).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(aspspConsentData).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @NotNull
    public SpiResponse<TransactionStatus> getPaymentStatusById(@NotNull SpiContextData spiContextData, @NotNull SpiBulkPayment payment, @NotNull AspspConsentData aspspConsentData) {
        try {
            ResponseEntity aspspResponse = this.aspspRestTemplate.getForEntity(this.aspspRemoteUrls.getPaymentStatus(), AspspTransactionStatus.class, new Object[]{payment.getPaymentId()});
            TransactionStatus status = this.spiPaymentMapper.mapToTransactionStatus((AspspTransactionStatus)aspspResponse.getBody());
            return SpiResponse.builder().aspspConsentData(aspspConsentData).payload((Object)status).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(aspspConsentData).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(aspspConsentData).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @NotNull
    public SpiResponse<SpiPaymentExecutionResponse> executePaymentWithoutSca(@NotNull SpiContextData spiContextData, @NotNull SpiBulkPayment payment, @NotNull AspspConsentData aspspConsentData) {
        Optional authMapOptional;
        TransactionStatus responseStatus = TransactionStatus.ACCP;
        AspspConsentData responseData = aspspConsentData;
        if (aspspConsentData.getAspspConsentData() != null && (authMapOptional = this.jsonConverter.toObject(aspspConsentData.getAspspConsentData(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */)).isPresent()) {
            String psuId;
            Map authMap = (Map)authMapOptional.get();
            if (!authMap.containsKey(psuId = spiContextData.getPsuData().getPsuId())) {
                return SpiResponse.builder().aspspConsentData(responseData).fail(SpiResponseStatus.LOGICAL_FAILURE);
            }
            authMap.put(psuId, true);
            responseStatus = authMap.values().contains(false) ? TransactionStatus.PATC : TransactionStatus.ACTC;
            byte[] bytes = this.jsonConverter.toJson((Object)authMap).map(String::getBytes).orElse(TEST_ASPSP_DATA.getBytes());
            responseData = aspspConsentData.respondWith(bytes);
        }
        AspspBulkPayment request = this.spiBulkPaymentMapper.mapToAspspBulkPayment(payment, responseStatus);
        try {
            this.aspspRestTemplate.postForEntity(this.aspspRemoteUrls.createBulkPayment(), (Object)request, AspspBulkPayment.class, new Object[0]);
            return SpiResponse.builder().aspspConsentData(responseData).payload((Object)new SpiPaymentExecutionResponse(responseStatus)).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(responseData).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(responseData).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @NotNull
    public SpiResponse<SpiPaymentExecutionResponse> verifyScaAuthorisationAndExecutePayment(@NotNull SpiContextData spiContextData, @NotNull SpiScaConfirmation spiScaConfirmation, @NotNull SpiBulkPayment payment, @NotNull AspspConsentData aspspConsentData) {
        TransactionStatus responseStatus = TransactionStatus.ACCP;
        AspspConsentData responseData = aspspConsentData;
        try {
            Optional authMapOptional;
            this.aspspRestTemplate.exchange(this.aspspRemoteUrls.applyStrongUserAuthorisation(), HttpMethod.PUT, new HttpEntity((Object)spiScaConfirmation), ResponseEntity.class, new Object[0]);
            if (aspspConsentData.getAspspConsentData() != null && (authMapOptional = this.jsonConverter.toObject(aspspConsentData.getAspspConsentData(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */)).isPresent()) {
                String psuId;
                Map authMap = (Map)authMapOptional.get();
                if (!authMap.containsKey(psuId = spiContextData.getPsuData().getPsuId())) {
                    return SpiResponse.builder().aspspConsentData(responseData).fail(SpiResponseStatus.LOGICAL_FAILURE);
                }
                authMap.put(psuId, true);
                responseStatus = authMap.values().contains(false) ? TransactionStatus.PATC : TransactionStatus.ACTC;
                byte[] bytes = this.jsonConverter.toJson((Object)authMap).map(String::getBytes).orElse(TEST_ASPSP_DATA.getBytes());
                responseData = aspspConsentData.respondWith(bytes);
            }
            AspspBulkPayment request = this.spiBulkPaymentMapper.mapToAspspBulkPayment(payment, responseStatus);
            this.aspspRestTemplate.postForEntity(this.aspspRemoteUrls.createBulkPayment(), (Object)request, AspspBulkPayment.class, new Object[0]);
            return SpiResponse.builder().aspspConsentData(responseData).payload((Object)new SpiPaymentExecutionResponse(responseStatus)).success();
        }
        catch (RestException e) {
            SpiResponseStatus spiResponseStatus = SpiResponseStatus.LOGICAL_FAILURE;
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                spiResponseStatus = SpiResponseStatus.TECHNICAL_FAILURE;
            } else if (e.getHttpStatus() == HttpStatus.UNAUTHORIZED) {
                spiResponseStatus = SpiResponseStatus.UNAUTHORIZED_FAILURE;
            }
            return SpiResponse.builder().aspspConsentData(responseData).fail(spiResponseStatus);
        }
    }

    @ConstructorProperties(value={"aspspRestTemplate", "aspspRemoteUrls", "spiPaymentMapper", "spiBulkPaymentMapper", "jsonConverter"})
    public BulkPaymentSpiImpl(RestTemplate aspspRestTemplate, AspspRemoteUrls aspspRemoteUrls, SpiPaymentMapper spiPaymentMapper, SpiBulkPaymentMapper spiBulkPaymentMapper, JsonConverter jsonConverter) {
        this.aspspRestTemplate = aspspRestTemplate;
        this.aspspRemoteUrls = aspspRemoteUrls;
        this.spiPaymentMapper = spiPaymentMapper;
        this.spiBulkPaymentMapper = spiBulkPaymentMapper;
        this.jsonConverter = jsonConverter;
    }
}

