/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.impl;

import de.adorsys.aspsp.xs2a.spi.config.rest.AspspRemoteUrls;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiSinglePayment;
import de.adorsys.aspsp.xs2a.spi.mapper.SpiPaymentMapper;
import de.adorsys.aspsp.xs2a.spi.mapper.SpiSinglePaymentMapper;
import de.adorsys.psd2.aspsp.mock.api.common.AspspTransactionStatus;
import de.adorsys.psd2.aspsp.mock.api.payment.AspspSinglePayment;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.exception.RestException;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaConfirmation;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiTransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiSinglePaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponseStatus;
import de.adorsys.psd2.xs2a.spi.service.SinglePaymentSpi;
import java.beans.ConstructorProperties;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class SinglePaymentSpiImpl
implements SinglePaymentSpi {
    private static final String TEST_ASPSP_DATA = "Test aspsp data";
    @Qualifier(value="aspspRestTemplate")
    private final RestTemplate aspspRestTemplate;
    private final AspspRemoteUrls aspspRemoteUrls;
    private final SpiPaymentMapper spiPaymentMapper;
    private final SpiSinglePaymentMapper spiSinglePaymentMapper;

    @NotNull
    public SpiResponse<SpiSinglePaymentInitiationResponse> initiatePayment(@NotNull SpiContextData spiContextData, @NotNull de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment payment, @NotNull AspspConsentData initialAspspConsentData) {
        try {
            AspspSinglePayment request = this.spiSinglePaymentMapper.mapToAspspSinglePayment(payment, SpiTransactionStatus.RCVD);
            ResponseEntity responseEntity = this.aspspRestTemplate.postForEntity(this.aspspRemoteUrls.createPayment(), (Object)request, AspspSinglePayment.class, new Object[0]);
            return SpiResponse.builder().aspspConsentData(initialAspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).payload((Object)this.spiSinglePaymentMapper.mapToSpiSinglePaymentResponse((AspspSinglePayment)responseEntity.getBody())).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(initialAspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(initialAspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @NotNull
    public SpiResponse<de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment> getPaymentById(@NotNull SpiContextData spiContextData, @NotNull de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment payment, @NotNull AspspConsentData aspspConsentData) {
        try {
            ResponseEntity aspspResponse = this.aspspRestTemplate.exchange(this.aspspRemoteUrls.getPaymentById(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{payment.getPaymentType().getValue(), payment.getPaymentProduct(), payment.getPaymentId()});
            AspspSinglePayment single = (AspspSinglePayment)((List)aspspResponse.getBody()).get(0);
            de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment spiPeriodicPayment = this.spiSinglePaymentMapper.mapToSpiSinglePayment(single, payment.getPaymentProduct());
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).payload((Object)spiPeriodicPayment).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @NotNull
    public SpiResponse<SpiTransactionStatus> getPaymentStatusById(@NotNull SpiContextData spiContextData, @NotNull de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment payment, @NotNull AspspConsentData aspspConsentData) {
        try {
            ResponseEntity aspspResponse = this.aspspRestTemplate.getForEntity(this.aspspRemoteUrls.getPaymentStatus(), AspspTransactionStatus.class, new Object[]{payment.getPaymentId()});
            SpiTransactionStatus status = this.spiPaymentMapper.mapToSpiTransactionStatus((AspspTransactionStatus)aspspResponse.getBody());
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).payload((Object)status).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @NotNull
    public SpiResponse<SpiResponse.VoidResponse> executePaymentWithoutSca(@NotNull SpiContextData spiContextData, @NotNull de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment payment, @NotNull AspspConsentData aspspConsentData) {
        AspspSinglePayment request = this.spiSinglePaymentMapper.mapToAspspSinglePayment(payment, SpiTransactionStatus.ACCP);
        try {
            this.aspspRestTemplate.postForEntity(this.aspspRemoteUrls.createPayment(), (Object)request, SpiSinglePayment.class, new Object[0]);
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).payload((Object)SpiResponse.voidResponse()).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @NotNull
    public SpiResponse<SpiResponse.VoidResponse> verifyScaAuthorisationAndExecutePayment(@NotNull SpiContextData spiContextData, @NotNull SpiScaConfirmation spiScaConfirmation, @NotNull de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment payment, @NotNull AspspConsentData aspspConsentData) {
        try {
            this.aspspRestTemplate.exchange(this.aspspRemoteUrls.applyStrongUserAuthorisation(), HttpMethod.PUT, new HttpEntity((Object)spiScaConfirmation), ResponseEntity.class, new Object[0]);
            AspspSinglePayment request = this.spiSinglePaymentMapper.mapToAspspSinglePayment(payment, SpiTransactionStatus.ACCP);
            this.aspspRestTemplate.postForEntity(this.aspspRemoteUrls.createPayment(), (Object)request, AspspSinglePayment.class, new Object[0]);
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).payload((Object)SpiResponse.voidResponse()).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @ConstructorProperties(value={"aspspRestTemplate", "aspspRemoteUrls", "spiPaymentMapper", "spiSinglePaymentMapper"})
    public SinglePaymentSpiImpl(RestTemplate aspspRestTemplate, AspspRemoteUrls aspspRemoteUrls, SpiPaymentMapper spiPaymentMapper, SpiSinglePaymentMapper spiSinglePaymentMapper) {
        this.aspspRestTemplate = aspspRestTemplate;
        this.aspspRemoteUrls = aspspRemoteUrls;
        this.spiPaymentMapper = spiPaymentMapper;
        this.spiSinglePaymentMapper = spiSinglePaymentMapper;
    }
}

