/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.mapper;

import de.adorsys.aspsp.xs2a.spi.mapper.SpiPaymentMapper;
import de.adorsys.aspsp.xs2a.spi.mapper.SpiSinglePaymentMapper;
import de.adorsys.psd2.aspsp.mock.api.payment.AspspBulkPayment;
import de.adorsys.psd2.aspsp.mock.api.payment.AspspSinglePayment;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiTransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiBulkPaymentInitiationResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class SpiBulkPaymentMapper {
    private final SpiSinglePaymentMapper spiSinglePaymentMapper;
    private final SpiPaymentMapper spiPaymentMapper;

    public AspspBulkPayment mapToAspspBulkPayment(@NotNull SpiBulkPayment payment, SpiTransactionStatus transactionStatus) {
        AspspBulkPayment bulk = new AspspBulkPayment();
        bulk.setPaymentId(payment.getPaymentId());
        bulk.setDebtorAccount(this.spiPaymentMapper.mapToAspspAccountReference(payment.getDebtorAccount()));
        bulk.setBatchBookingPreferred(payment.getBatchBookingPreferred());
        bulk.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        bulk.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        bulk.setPayments(this.mapToListAspspSinglePayment(payment, transactionStatus));
        bulk.setPaymentStatus(this.spiPaymentMapper.mapToAspspTransactionStatus(transactionStatus));
        return bulk;
    }

    public SpiBulkPaymentInitiationResponse mapToSpiBulkPaymentResponse(@NotNull AspspBulkPayment payment, String paymentProduct) {
        SpiBulkPaymentInitiationResponse spi = new SpiBulkPaymentInitiationResponse();
        spi.setPayments(this.mapToListSpiSinglePayments(payment.getPayments(), paymentProduct));
        spi.setPaymentId(payment.getPaymentId());
        if (payment.getPaymentId() == null) {
            spi.setTransactionStatus(SpiTransactionStatus.RJCT);
        } else {
            spi.setTransactionStatus(SpiTransactionStatus.RCVD);
        }
        return spi;
    }

    public SpiBulkPayment mapToSpiBulkPayment(@NotNull List<AspspSinglePayment> payments, String paymentProduct) {
        SpiBulkPayment bulk = new SpiBulkPayment();
        bulk.setPayments(this.mapToListSpiSinglePayments(payments, paymentProduct));
        bulk.setPaymentStatus(this.spiPaymentMapper.mapToSpiTransactionStatus(payments.get(0).getPaymentStatus()));
        return bulk;
    }

    private List<AspspSinglePayment> mapToListAspspSinglePayment(@NotNull SpiBulkPayment payment, SpiTransactionStatus transactionStatus) {
        return payment.getPayments().stream().map(p -> this.spiSinglePaymentMapper.mapToAspspSinglePayment(p, transactionStatus)).collect(Collectors.toList());
    }

    private List<SpiSinglePayment> mapToListSpiSinglePayments(@NotNull List<AspspSinglePayment> payments, String paymentProduct) {
        return payments.stream().map(p -> this.spiSinglePaymentMapper.mapToSpiSinglePayment(p, paymentProduct)).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"spiSinglePaymentMapper", "spiPaymentMapper"})
    public SpiBulkPaymentMapper(SpiSinglePaymentMapper spiSinglePaymentMapper, SpiPaymentMapper spiPaymentMapper) {
        this.spiSinglePaymentMapper = spiSinglePaymentMapper;
        this.spiPaymentMapper = spiPaymentMapper;
    }
}

