/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.impl;

import de.adorsys.aspsp.xs2a.exception.RestException;
import de.adorsys.aspsp.xs2a.spi.config.rest.AspspRemoteUrls;
import de.adorsys.aspsp.xs2a.spi.mapper.SpiPaymentMapper;
import de.adorsys.aspsp.xs2a.spi.mapper.SpiPeriodicPaymentMapper;
import de.adorsys.psd2.aspsp.mock.api.common.AspspTransactionStatus;
import de.adorsys.psd2.aspsp.mock.api.payment.AspspPeriodicPayment;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaConfirmation;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiTransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPeriodicPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponseStatus;
import de.adorsys.psd2.xs2a.spi.service.PeriodicPaymentSpi;
import java.beans.ConstructorProperties;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class PeriodicPaymentSpiImpl
implements PeriodicPaymentSpi {
    private static final String TEST_ASPSP_DATA = "Test aspsp data";
    @Qualifier(value="aspspRestTemplate")
    private final RestTemplate aspspRestTemplate;
    private final AspspRemoteUrls aspspRemoteUrls;
    private final SpiPaymentMapper spiPaymentMapper;
    private final SpiPeriodicPaymentMapper spiPeriodicPaymentMapper;

    @NotNull
    public SpiResponse<SpiPeriodicPaymentInitiationResponse> initiatePayment(@NotNull SpiPsuData psuData, @NotNull SpiPeriodicPayment payment, @NotNull AspspConsentData initialAspspConsentData) {
        try {
            AspspPeriodicPayment request = this.spiPeriodicPaymentMapper.mapToAspspPeriodicPayment(payment, SpiTransactionStatus.RCVD);
            ResponseEntity aspspResponse = this.aspspRestTemplate.postForEntity(this.aspspRemoteUrls.createPeriodicPayment(), (Object)request, AspspPeriodicPayment.class, new Object[0]);
            return SpiResponse.builder().aspspConsentData(initialAspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).payload((Object)this.spiPeriodicPaymentMapper.mapToSpiPeriodicPaymentResponse((AspspPeriodicPayment)aspspResponse.getBody())).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(initialAspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(initialAspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @NotNull
    public SpiResponse<SpiPeriodicPayment> getPaymentById(@NotNull SpiPsuData psuData, @NotNull SpiPeriodicPayment payment, @NotNull AspspConsentData aspspConsentData) {
        try {
            ResponseEntity aspspResponse = this.aspspRestTemplate.exchange(this.aspspRemoteUrls.getPaymentById(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{payment.getPaymentType().getValue(), payment.getPaymentProduct().getValue(), payment.getPaymentId()});
            AspspPeriodicPayment periodic = (AspspPeriodicPayment)((List)aspspResponse.getBody()).get(0);
            SpiPeriodicPayment spiPeriodicPayment = this.spiPeriodicPaymentMapper.mapToSpiPeriodicPayment(periodic, payment.getPaymentProduct());
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).payload((Object)spiPeriodicPayment).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @NotNull
    public SpiResponse<SpiTransactionStatus> getPaymentStatusById(@NotNull SpiPsuData psuData, @NotNull SpiPeriodicPayment payment, @NotNull AspspConsentData aspspConsentData) {
        try {
            ResponseEntity aspspResponse = this.aspspRestTemplate.getForEntity(this.aspspRemoteUrls.getPaymentStatus(), AspspTransactionStatus.class, new Object[]{payment.getPaymentId()});
            SpiTransactionStatus status = this.spiPaymentMapper.mapToSpiTransactionStatus((AspspTransactionStatus)aspspResponse.getBody());
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).payload((Object)status).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @NotNull
    public SpiResponse<SpiResponse.VoidResponse> executePaymentWithoutSca(@NotNull SpiPsuData psuData, @NotNull SpiPeriodicPayment payment, @NotNull AspspConsentData aspspConsentData) {
        AspspPeriodicPayment request = this.spiPeriodicPaymentMapper.mapToAspspPeriodicPayment(payment, SpiTransactionStatus.ACCP);
        try {
            this.aspspRestTemplate.postForEntity(this.aspspRemoteUrls.createPeriodicPayment(), (Object)request, AspspPeriodicPayment.class, new Object[0]);
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @NotNull
    public SpiResponse<SpiResponse.VoidResponse> verifyScaAuthorisationAndExecutePayment(@NotNull SpiPsuData psuData, @NotNull SpiScaConfirmation spiScaConfirmation, @NotNull SpiPeriodicPayment payment, @NotNull AspspConsentData aspspConsentData) {
        try {
            this.aspspRestTemplate.exchange(this.aspspRemoteUrls.applyStrongUserAuthorisation(), HttpMethod.PUT, new HttpEntity((Object)spiScaConfirmation), ResponseEntity.class, new Object[0]);
            AspspPeriodicPayment request = this.spiPeriodicPaymentMapper.mapToAspspPeriodicPayment(payment, SpiTransactionStatus.ACCP);
            this.aspspRestTemplate.postForEntity(this.aspspRemoteUrls.createPeriodicPayment(), (Object)request, AspspPeriodicPayment.class, new Object[0]);
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @ConstructorProperties(value={"aspspRestTemplate", "aspspRemoteUrls", "spiPaymentMapper", "spiPeriodicPaymentMapper"})
    public PeriodicPaymentSpiImpl(RestTemplate aspspRestTemplate, AspspRemoteUrls aspspRemoteUrls, SpiPaymentMapper spiPaymentMapper, SpiPeriodicPaymentMapper spiPeriodicPaymentMapper) {
        this.aspspRestTemplate = aspspRestTemplate;
        this.aspspRemoteUrls = aspspRemoteUrls;
        this.spiPaymentMapper = spiPaymentMapper;
        this.spiPeriodicPaymentMapper = spiPeriodicPaymentMapper;
    }
}

