/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.impl;

import de.adorsys.aspsp.xs2a.exception.RestException;
import de.adorsys.aspsp.xs2a.spi.config.rest.AspspRemoteUrls;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiBalanceType;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiAmount;
import de.adorsys.psd2.xs2a.spi.domain.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.spi.domain.fund.SpiFundsConfirmationConsent;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponseStatus;
import de.adorsys.psd2.xs2a.spi.service.FundsConfirmationSpi;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class FundsConfirmationSpiImpl
implements FundsConfirmationSpi {
    private static final String TEST_ASPSP_DATA = "Test aspsp data";
    @Qualifier(value="aspspRestTemplate")
    private final RestTemplate aspspRestTemplate;
    private final AspspRemoteUrls remoteSpiUrls;

    @NotNull
    public SpiResponse<Boolean> performFundsSufficientCheck(@NotNull SpiPsuData psuData, @Nullable SpiFundsConfirmationConsent consent, @NotNull SpiAccountReference reference, @NotNull SpiAmount amount, @NotNull AspspConsentData aspspConsentData) {
        try {
            List accounts = Optional.ofNullable(this.aspspRestTemplate.exchange(this.remoteSpiUrls.getAccountDetailsByIban(), HttpMethod.GET, new HttpEntity(null), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{reference.getIban()}).getBody()).orElseGet(Collections::emptyList);
            List balances = this.extractAccountBalancesByCurrency(accounts, reference.getCurrency());
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).payload((Object)this.isBalancesSufficient(balances, amount)).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    private boolean isBalancesSufficient(List<SpiAccountBalance> balances, SpiAmount amount) {
        return balances.stream().filter(bal -> SpiBalanceType.INTERIM_AVAILABLE == bal.getSpiBalanceType()).findFirst().map(SpiAccountBalance::getSpiBalanceAmount).map(am -> this.isRequiredAmountEnough(amount, am)).orElse(false);
    }

    private boolean isRequiredAmountEnough(SpiAmount requiredAmount, SpiAmount availableAmount) {
        return availableAmount.getAmount().compareTo(requiredAmount.getAmount()) >= 0 && availableAmount.getCurrency() == requiredAmount.getCurrency();
    }

    private List<SpiAccountBalance> extractAccountBalancesByCurrency(List<SpiAccountDetails> accounts, Currency currency) {
        return accounts.stream().filter(spiAcc -> spiAcc.getCurrency() == currency).findFirst().map(SpiAccountDetails::getBalances).orElseGet(Collections::emptyList);
    }

    @ConstructorProperties(value={"aspspRestTemplate", "remoteSpiUrls"})
    public FundsConfirmationSpiImpl(RestTemplate aspspRestTemplate, AspspRemoteUrls remoteSpiUrls) {
        this.aspspRestTemplate = aspspRestTemplate;
        this.remoteSpiUrls = remoteSpiUrls;
    }
}

