/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.impl;

import de.adorsys.aspsp.xs2a.exception.RestException;
import de.adorsys.aspsp.xs2a.spi.config.rest.AspspRemoteUrls;
import de.adorsys.aspsp.xs2a.spi.mapper.SpiBulkPaymentMapper;
import de.adorsys.aspsp.xs2a.spi.mapper.SpiPaymentMapper;
import de.adorsys.psd2.aspsp.mock.api.common.AspspTransactionStatus;
import de.adorsys.psd2.aspsp.mock.api.payment.AspspBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaConfirmation;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiTransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiBulkPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponseStatus;
import de.adorsys.psd2.xs2a.spi.service.BulkPaymentSpi;
import java.beans.ConstructorProperties;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class BulkPaymentSpiImpl
implements BulkPaymentSpi {
    private static final String TEST_ASPSP_DATA = "Test aspsp data";
    @Qualifier(value="aspspRestTemplate")
    private final RestTemplate aspspRestTemplate;
    private final AspspRemoteUrls aspspRemoteUrls;
    private final SpiPaymentMapper spiPaymentMapper;
    private final SpiBulkPaymentMapper spiBulkPaymentMapper;

    @NotNull
    public SpiResponse<SpiBulkPaymentInitiationResponse> initiatePayment(@NotNull SpiPsuData psuData, @NotNull SpiBulkPayment payment, @NotNull AspspConsentData initialAspspConsentData) {
        try {
            AspspBulkPayment request = this.spiBulkPaymentMapper.mapToAspspBulkPayment(payment, SpiTransactionStatus.RCVD);
            ResponseEntity responseEntity = this.aspspRestTemplate.postForEntity(this.aspspRemoteUrls.createBulkPayment(), (Object)request, AspspBulkPayment.class, new Object[0]);
            SpiBulkPaymentInitiationResponse response = this.spiBulkPaymentMapper.mapToSpiBulkPaymentResponse((AspspBulkPayment)responseEntity.getBody(), payment.getPaymentProduct());
            return SpiResponse.builder().aspspConsentData(initialAspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).payload((Object)response).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(initialAspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(initialAspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @NotNull
    public SpiResponse<SpiBulkPayment> getPaymentById(@NotNull SpiPsuData psuData, @NotNull SpiBulkPayment payment, @NotNull AspspConsentData aspspConsentData) {
        try {
            ResponseEntity aspspResponse = this.aspspRestTemplate.exchange(this.aspspRemoteUrls.getPaymentById(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{payment.getPaymentType().getValue(), payment.getPaymentProduct().getValue(), payment.getPaymentId()});
            List payments = (List)aspspResponse.getBody();
            SpiBulkPayment spiBulkPayment = this.spiBulkPaymentMapper.mapToSpiBulkPayment(payments, payment.getPaymentProduct());
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).payload((Object)spiBulkPayment).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @NotNull
    public SpiResponse<SpiTransactionStatus> getPaymentStatusById(@NotNull SpiPsuData psuData, @NotNull SpiBulkPayment payment, @NotNull AspspConsentData aspspConsentData) {
        try {
            ResponseEntity aspspResponse = this.aspspRestTemplate.getForEntity(this.aspspRemoteUrls.getPaymentStatus(), AspspTransactionStatus.class, new Object[]{payment.getPaymentId()});
            SpiTransactionStatus status = this.spiPaymentMapper.mapToSpiTransactionStatus((AspspTransactionStatus)aspspResponse.getBody());
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).payload((Object)status).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @NotNull
    public SpiResponse<SpiResponse.VoidResponse> executePaymentWithoutSca(@NotNull SpiPsuData psuData, @NotNull SpiBulkPayment payment, @NotNull AspspConsentData aspspConsentData) {
        AspspBulkPayment request = this.spiBulkPaymentMapper.mapToAspspBulkPayment(payment, SpiTransactionStatus.ACCP);
        try {
            this.aspspRestTemplate.postForEntity(this.aspspRemoteUrls.createBulkPayment(), (Object)request, AspspBulkPayment.class, new Object[0]);
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @NotNull
    public SpiResponse<SpiResponse.VoidResponse> verifyScaAuthorisationAndExecutePayment(@NotNull SpiPsuData psuData, @NotNull SpiScaConfirmation spiScaConfirmation, @NotNull SpiBulkPayment payment, @NotNull AspspConsentData aspspConsentData) {
        try {
            this.aspspRestTemplate.exchange(this.aspspRemoteUrls.applyStrongUserAuthorisation(), HttpMethod.PUT, new HttpEntity((Object)spiScaConfirmation), ResponseEntity.class, new Object[0]);
            AspspBulkPayment request = this.spiBulkPaymentMapper.mapToAspspBulkPayment(payment, SpiTransactionStatus.ACCP);
            this.aspspRestTemplate.postForEntity(this.aspspRemoteUrls.createBulkPayment(), (Object)request, AspspBulkPayment.class, new Object[0]);
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @ConstructorProperties(value={"aspspRestTemplate", "aspspRemoteUrls", "spiPaymentMapper", "spiBulkPaymentMapper"})
    public BulkPaymentSpiImpl(RestTemplate aspspRestTemplate, AspspRemoteUrls aspspRemoteUrls, SpiPaymentMapper spiPaymentMapper, SpiBulkPaymentMapper spiBulkPaymentMapper) {
        this.aspspRestTemplate = aspspRestTemplate;
        this.aspspRemoteUrls = aspspRemoteUrls;
        this.spiPaymentMapper = spiPaymentMapper;
        this.spiBulkPaymentMapper = spiBulkPaymentMapper;
    }
}

