/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.impl;

import de.adorsys.aspsp.xs2a.exception.RestException;
import de.adorsys.aspsp.xs2a.spi.config.rest.AspspRemoteUrls;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiBalanceReport;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransaction;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransactionReport;
import de.adorsys.psd2.xs2a.spi.domain.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiAccountAccess;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponseStatus;
import de.adorsys.psd2.xs2a.spi.service.AccountSpi;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class AccountSpiImpl
implements AccountSpi {
    private static final String TEST_ASPSP_DATA = "Test aspsp data";
    private final AspspRemoteUrls remoteSpiUrls;
    @Qualifier(value="aspspRestTemplate")
    private final RestTemplate aspspRestTemplate;

    public SpiResponse<List<SpiAccountDetails>> requestAccountDetails(boolean withBalance, @NotNull SpiAccountConsent accountConsent, @NotNull AspspConsentData aspspConsentData) {
        try {
            List accountDetailsList = this.isBankOfferedConsent(accountConsent.getAccess()) ? this.getAccountDetailsByConsentId(accountConsent) : this.getAccountDetailsFromReferences(withBalance, accountConsent);
            return SpiResponse.builder().payload((Object)this.filterAccountDetailsByWithBalance(withBalance, accountDetailsList)).aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    public SpiResponse<SpiAccountDetails> requestAccountDetailForAccount(@NotNull String accountId, boolean withBalance, @NotNull SpiAccountConsent accountConsent, @NotNull AspspConsentData aspspConsentData) {
        try {
            SpiAccountDetails accountDetails = (SpiAccountDetails)this.aspspRestTemplate.getForObject(this.remoteSpiUrls.getAccountDetailsById(), SpiAccountDetails.class, new Object[]{accountId});
            if (!withBalance) {
                accountDetails.emptyBalances();
            }
            return SpiResponse.builder().payload((Object)accountDetails).aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    public SpiResponse<SpiTransactionReport> requestTransactionsForAccount(@NotNull String accountId, boolean withBalance, @NotNull LocalDate dateFrom, @NotNull LocalDate dateTo, @NotNull SpiAccountConsent accountConsent, @NotNull AspspConsentData aspspConsentData) {
        try {
            SpiAccountDetails accountDetails = (SpiAccountDetails)this.aspspRestTemplate.getForObject(this.remoteSpiUrls.getAccountDetailsById(), SpiAccountDetails.class, new Object[]{accountId});
            HashMap<String, String> uriParams = new HashMap<String, String>();
            uriParams.put("account-id", accountId);
            UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)this.remoteSpiUrls.readTransactionsByPeriod()).queryParam("dateFrom", new Object[]{dateFrom}).queryParam("dateTo", new Object[]{dateTo}).buildAndExpand(uriParams);
            Optional<Object> transactionsOptional = Optional.ofNullable(this.aspspRestTemplate.exchange(uriComponents.toUriString(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]).getBody());
            SpiAccountReference accountReference = new SpiAccountReference(accountDetails);
            List transactions = transactionsOptional.orElseGet(ArrayList::new);
            List balances = null;
            if (withBalance) {
                balances = accountDetails.getBalances();
            }
            SpiTransactionReport transactionReport = new SpiTransactionReport(accountReference, transactions, balances);
            return SpiResponse.builder().payload((Object)transactionReport).aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    public SpiResponse<SpiTransaction> requestTransactionForAccountByTransactionId(@NotNull String transactionId, @NotNull String accountId, @NotNull SpiAccountConsent accountConsent, @NotNull AspspConsentData aspspConsentData) {
        try {
            SpiTransaction transaction = (SpiTransaction)this.aspspRestTemplate.getForObject(this.remoteSpiUrls.readTransactionById(), SpiTransaction.class, new Object[]{transactionId, accountId});
            return SpiResponse.builder().payload((Object)transaction).aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    public SpiResponse<SpiBalanceReport> requestBalancesForAccount(@NotNull String accountId, @NotNull SpiAccountConsent accountConsent, @NotNull AspspConsentData aspspConsentData) {
        try {
            SpiAccountDetails accountDetails = (SpiAccountDetails)this.aspspRestTemplate.getForObject(this.remoteSpiUrls.getAccountDetailsById(), SpiAccountDetails.class, new Object[]{accountId});
            List accountBalances = (List)this.aspspRestTemplate.exchange(this.remoteSpiUrls.getBalancesByAccountId(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{accountId}).getBody();
            SpiBalanceReport balanceReport = new SpiBalanceReport();
            balanceReport.setBalances(accountBalances);
            if (accountDetails != null) {
                balanceReport.setAccountReference(new SpiAccountReference(accountDetails));
            }
            return SpiResponse.builder().payload((Object)balanceReport).aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    private boolean isBankOfferedConsent(SpiAccountAccess accountAccess) {
        return CollectionUtils.isEmpty((Collection)accountAccess.getBalances()) && CollectionUtils.isEmpty((Collection)accountAccess.getTransactions()) && CollectionUtils.isEmpty((Collection)accountAccess.getAccounts());
    }

    private List<SpiAccountDetails> getAccountDetailsByConsentId(SpiAccountConsent accountConsent) {
        return Optional.ofNullable(this.aspspRestTemplate.exchange(this.remoteSpiUrls.getAccountDetailsByPsuId(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{accountConsent.getPsuId()}).getBody()).orElseGet(Collections::emptyList);
    }

    private List<SpiAccountDetails> getAccountDetailsFromReferences(boolean withBalance, SpiAccountConsent accountConsent) {
        SpiAccountAccess accountAccess = accountConsent.getAccess();
        List references = withBalance ? accountAccess.getBalances() : accountAccess.getAccounts();
        return this.getAccountDetailsFromReferences(references);
    }

    private List<SpiAccountDetails> getAccountDetailsFromReferences(List<SpiAccountReference> references) {
        if (CollectionUtils.isEmpty(references)) {
            return Collections.emptyList();
        }
        return references.stream().map(arg_0 -> this.getAccountDetailsByAccountReference(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<SpiAccountDetails> getAccountDetailsByAccountReference(SpiAccountReference reference) {
        if (reference == null) {
            return Optional.empty();
        }
        List accountDetails = Optional.ofNullable(this.aspspRestTemplate.exchange(this.remoteSpiUrls.getAccountDetailsByIban(), HttpMethod.GET, new HttpEntity(null), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{reference.getIban()}).getBody()).orElseGet(Collections::emptyList);
        return accountDetails.stream().filter(acc -> acc.getCurrency() == reference.getCurrency()).findFirst();
    }

    private List<SpiAccountDetails> filterAccountDetailsByWithBalance(boolean withBalance, List<SpiAccountDetails> details) {
        if (!withBalance) {
            details.forEach(SpiAccountDetails::emptyBalances);
        }
        return details;
    }

    @ConstructorProperties(value={"remoteSpiUrls", "aspspRestTemplate"})
    public AccountSpiImpl(AspspRemoteUrls remoteSpiUrls, RestTemplate aspspRestTemplate) {
        this.remoteSpiUrls = remoteSpiUrls;
        this.aspspRestTemplate = aspspRestTemplate;
    }
}

