/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.service;

import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtRestClient;
import de.adorsys.psd2.sandbox.tpp.db.api.domain.OperationInfoEntity;
import de.adorsys.psd2.sandbox.tpp.db.api.domain.OperationTypeEntity;
import de.adorsys.psd2.sandbox.tpp.db.api.repository.OperationInfoRepository;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.OperationInfo;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.OperationType;
import de.adorsys.psd2.sandbox.tpp.rest.server.exception.TppException;
import de.adorsys.psd2.sandbox.tpp.rest.server.mapper.OperationInfoMapper;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class TppOperationInfoService {
    private final OperationInfoRepository infoRepository;
    private final UserMgmtRestClient userMgmtRestClient;
    private final OperationInfoMapper infoMapper;

    public List<OperationInfo> getOperationsByTypeAndTppId(OperationType operationType) {
        String tppId = this.validateAndGetTppId();
        List infos = Optional.ofNullable(operationType).map(o -> this.infoRepository.findAllByTppIdAndOperationTypeOrderByCreatedDesc(tppId, OperationTypeEntity.valueOf((String)o.name()))).orElseGet(() -> this.infoRepository.findAllByTppIdOrderByCreatedDesc(tppId));
        return this.infoMapper.toOperationInfos(infos);
    }

    public OperationInfo createInfo(OperationInfo operationInfo) {
        String tppId = this.validateAndGetTppId();
        operationInfo.setTppId(tppId);
        OperationInfoEntity infoEntity = this.infoMapper.toOperationInfoEntity(operationInfo);
        return this.infoMapper.toOperationInfo((OperationInfoEntity)this.infoRepository.save((Object)infoEntity));
    }

    public void deleteInfo(Long operationInfoId) {
        String tppId = this.validateAndGetTppId();
        if (!this.infoRepository.existsByIdAndTppId(operationInfoId, tppId)) {
            throw new TppException("Requested data doesnt belong to Your TPP", 403);
        }
        this.infoRepository.deleteById((Object)operationInfoId);
    }

    private String validateAndGetTppId() {
        UserTO user = (UserTO)this.userMgmtRestClient.getUser().getBody();
        if (user == null || !user.getUserRoles().contains(UserRoleTO.STAFF) || StringUtils.isBlank((CharSequence)user.getId())) {
            throw new TppException("Only TPPs are allowed to query this data", 403);
        }
        return user.getId();
    }

    public TppOperationInfoService(OperationInfoRepository infoRepository, UserMgmtRestClient userMgmtRestClient, OperationInfoMapper infoMapper) {
        this.infoRepository = infoRepository;
        this.userMgmtRestClient = userMgmtRestClient;
        this.infoMapper = infoMapper;
    }
}

