/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.service;

import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtRestClient;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.BankCodeStructure;
import de.adorsys.psd2.sandbox.tpp.rest.server.exception.TppException;
import de.adorsys.psd2.sandbox.tpp.rest.server.model.DataPayload;
import de.adorsys.psd2.sandbox.tpp.rest.server.model.TppData;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.iban4j.CountryCode;
import org.iban4j.Iban;
import org.iban4j.bban.BbanEntryType;
import org.iban4j.bban.BbanStructure;
import org.iban4j.bban.BbanStructureEntry;
import org.springframework.stereotype.Service;

@Service
public class IbanGenerationService {
    private static final List<CountryCode> COUNTRY_CODES = Arrays.asList(CountryCode.AD, CountryCode.AL, CountryCode.AT, CountryCode.BE, CountryCode.BG, CountryCode.CH, CountryCode.CY, CountryCode.CZ, CountryCode.DE, CountryCode.DK, CountryCode.EE, CountryCode.ES, CountryCode.FI, CountryCode.FR, CountryCode.GB, CountryCode.GL, CountryCode.GR, CountryCode.HR, CountryCode.HU, CountryCode.IE, CountryCode.IL, CountryCode.IS, CountryCode.IT, CountryCode.LI, CountryCode.LT, CountryCode.LU, CountryCode.LV, CountryCode.MC, CountryCode.MD, CountryCode.MK, CountryCode.MT, CountryCode.NL, CountryCode.NO, CountryCode.PL, CountryCode.PT, CountryCode.RO, CountryCode.RS, CountryCode.SE, CountryCode.SI, CountryCode.SK, CountryCode.UA, CountryCode.VG, CountryCode.XK);
    private final UserMgmtRestClient userMgmtRestClient;

    public String generateNextIban(String tppId) {
        TppData data = this.getTppData(tppId);
        return this.generateIban(data.getCountryCode(), data.getBranchId(), data.getNextAccountNumber());
    }

    public String generateIbanForNisp(DataPayload payload, String iban) {
        if (payload.getGeneratedIbans().containsKey(iban)) {
            return (String)payload.getGeneratedIbans().get(iban);
        }
        TppData data = new TppData((UserTO)this.userMgmtRestClient.getUser().getBody());
        String generatedIban = this.generateIban(data.getCountryCode(), data.getBranchId(), Long.parseLong(iban));
        payload.getGeneratedIbans().put(iban, generatedIban);
        return generatedIban;
    }

    public Map<CountryCode, String> getCountryCodes() {
        EnumMap codes = new EnumMap(CountryCode.class);
        COUNTRY_CODES.forEach(c -> codes.put((CountryCode)c, c.getName()));
        return TppData.sortMapByValue(codes);
    }

    public BankCodeStructure getBankCodeStructure(CountryCode code) {
        return new BankCodeStructure(code);
    }

    private String generateIban(CountryCode countryCode, String bankCode, long accountNr) {
        int accountNumberLength = BbanStructure.forCountry((CountryCode)countryCode).getEntries().stream().filter(e -> e.getEntryType().equals((Object)BbanEntryType.account_number)).findFirst().map(BbanStructureEntry::getLength).orElse(0);
        String formatParam = "%0" + accountNumberLength + "d";
        String accountNumber = String.format(formatParam, accountNr);
        return new Iban.Builder().countryCode(countryCode).bankCode(bankCode).accountNumber(accountNumber).buildRandom().toString();
    }

    private TppData getTppData(String tppId) {
        UserTO user = (UserTO)this.userMgmtRestClient.getUserById(tppId).getBody();
        if (!Objects.requireNonNull(user).getUserRoles().contains(UserRoleTO.STAFF)) {
            throw new TppException("You're trying to generate Iban out of Tpp range", 400);
        }
        return new TppData(user);
    }

    public IbanGenerationService(UserMgmtRestClient userMgmtRestClient) {
        this.userMgmtRestClient = userMgmtRestClient;
    }
}

