/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.mapper;

import de.adorsys.ledgers.middleware.api.domain.account.MockBookingDetails;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.UserTransaction;
import de.adorsys.psd2.sandbox.tpp.rest.server.mapper.MockTransactionDataConverter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class MockTransactionDataConverterImpl
implements MockTransactionDataConverter {
    public List<MockBookingDetails> toLedgersMockTransactions(List<UserTransaction> transactions) {
        if (transactions == null) {
            return null;
        }
        ArrayList<MockBookingDetails> list = new ArrayList<MockBookingDetails>(transactions.size());
        for (UserTransaction userTransaction : transactions) {
            list.add(this.toLedgersMockTransaction(userTransaction));
        }
        return list;
    }

    public MockBookingDetails toLedgersMockTransaction(UserTransaction transaction) {
        if (transaction == null) {
            return null;
        }
        MockBookingDetails mockBookingDetails = new MockBookingDetails();
        mockBookingDetails.setUserAccount(transaction.getId());
        mockBookingDetails.setBookingDate(this.toLocalDate(transaction.getPostingDate()));
        mockBookingDetails.setValueDate(this.toLocalDate(transaction.getValueDate()));
        mockBookingDetails.setRemittance(transaction.getUsage());
        mockBookingDetails.setCrDrName(transaction.getPayer());
        mockBookingDetails.setOtherAccount(transaction.getAccountNumber());
        if (transaction.getAmount() != null) {
            mockBookingDetails.setAmount(new BigDecimal(transaction.getAmount()));
        }
        if (transaction.getCurrency() != null) {
            mockBookingDetails.setCurrency(Currency.getInstance(transaction.getCurrency()));
        }
        return mockBookingDetails;
    }
}

