/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.controller;

import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtRestClient;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtStaffRestClient;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.User;
import de.adorsys.psd2.sandbox.tpp.rest.api.resource.TppUsersRestApi;
import de.adorsys.psd2.sandbox.tpp.rest.server.exception.TppException;
import de.adorsys.psd2.sandbox.tpp.rest.server.mapper.UserMapper;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tpp/users"})
public class TppUsersController
implements TppUsersRestApi {
    private final UserMapper userMapper;
    private final UserMgmtStaffRestClient userMgmtStaffRestClient;
    private final UserMgmtRestClient userMgmtRestClient;

    public ResponseEntity<UserTO> createUser(User user) {
        UserTO userTO = this.userMapper.toUserTO(user);
        return this.userMgmtStaffRestClient.createUser(userTO);
    }

    public ResponseEntity<CustomPageImpl<UserTO>> getAllUsers(String queryParam, int page, int size) {
        CustomPageImpl userPage = Optional.ofNullable((CustomPageImpl)this.userMgmtStaffRestClient.getBranchUsersByRoles(Collections.singletonList(UserRoleTO.CUSTOMER), queryParam, null, page, size).getBody()).orElse(new CustomPageImpl());
        return ResponseEntity.ok((Object)userPage);
    }

    public ResponseEntity<Void> updateUser(User user) {
        if (StringUtils.isBlank((CharSequence)user.getId())) {
            throw new TppException("User id is not present in body!", 400);
        }
        String branch = Optional.ofNullable((UserTO)this.userMgmtRestClient.getUser().getBody()).map(UserTO::getBranch).orElseThrow(() -> new TppException("No tpp code present!", 400));
        UserTO userTO = this.userMapper.toUserTO(user);
        userTO.setBranch(branch);
        this.userMgmtStaffRestClient.modifyUser(branch, userTO);
        return new ResponseEntity(HttpStatus.OK);
    }

    public ResponseEntity<UserTO> getUser(String userId) {
        return this.userMgmtStaffRestClient.getBranchUserById(userId);
    }

    public ResponseEntity<UserTO> getSelf() {
        return this.userMgmtRestClient.getUser();
    }

    public ResponseEntity<Boolean> changeStatus(String userId) {
        return this.userMgmtStaffRestClient.changeStatus(userId);
    }

    public ResponseEntity<Void> resetPasswordViaEmail(String login) {
        this.userMgmtRestClient.resetPasswordViaEmail(login);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    public TppUsersController(UserMapper userMapper, UserMgmtStaffRestClient userMgmtStaffRestClient, UserMgmtRestClient userMgmtRestClient) {
        this.userMapper = userMapper;
        this.userMgmtStaffRestClient = userMgmtStaffRestClient;
        this.userMgmtRestClient = userMgmtRestClient;
    }
}

