/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.controller;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsExtendedTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserExtendedTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.client.rest.AdminRestClient;
import de.adorsys.ledgers.middleware.client.rest.DataRestClient;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtStaffRestClient;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import de.adorsys.psd2.sandbox.tpp.cms.api.service.CmsDbNativeService;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.User;
import de.adorsys.psd2.sandbox.tpp.rest.api.resource.TppAdminRestApi;
import de.adorsys.psd2.sandbox.tpp.rest.server.mapper.UserMapper;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tpp/admin"})
public class TppAdminController
implements TppAdminRestApi {
    private static final Logger log = LoggerFactory.getLogger(TppAdminController.class);
    private static final int PAUSE_AFTER_BATCH = 20;
    private final UserMapper userMapper;
    private final DataRestClient dataRestClient;
    private final AdminRestClient adminRestClient;
    private final UserMgmtStaffRestClient userMgmtStaffRestClient;
    private final CmsDbNativeService cmsDbNativeService;

    public ResponseEntity<CustomPageImpl<UserExtendedTO>> users(String countryCode, String tppId, String tppLogin, String userLogin, UserRoleTO role, Boolean blocked, int page, int size) {
        return this.adminRestClient.users(countryCode, tppId, tppLogin, userLogin, role, blocked, page, size);
    }

    public ResponseEntity<Void> user(UserTO user) {
        return this.adminRestClient.user(user);
    }

    public ResponseEntity<CustomPageImpl<AccountDetailsExtendedTO>> accounts(String countryCode, String tppId, String tppLogin, String ibanParam, Boolean isBlocked, int page, int size) {
        return this.adminRestClient.accounts(countryCode, tppId, tppLogin, ibanParam, isBlocked, page, size);
    }

    public ResponseEntity<Void> register(User user, String tppId) {
        UserTO userTO = this.userMapper.toUserTO(user);
        if (userTO.getUserRoles().contains(UserRoleTO.CUSTOMER)) {
            userTO.setBranch(tppId);
        }
        this.adminRestClient.register(userTO);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }

    public ResponseEntity<Void> admin(User user) {
        UserTO userTO = this.userMapper.toUserTO(user);
        userTO.setUserRoles(Collections.singletonList(UserRoleTO.SYSTEM));
        this.adminRestClient.register(userTO);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }

    public ResponseEntity<CustomPageImpl<UserTO>> admins(int page, int size) {
        return this.adminRestClient.admins(page, size);
    }

    public ResponseEntity<Void> remove(String tppId) {
        ResponseEntity loginsByBranchIdResponse = this.userMgmtStaffRestClient.getBranchUserLoginsByBranchId(tppId);
        List logins = (List)loginsByBranchIdResponse.getBody();
        this.dataRestClient.branch(tppId);
        log.debug("User data for login [{}] was removed from Ledgers.", (Object)tppId);
        this.cmsDbNativeService.deleteConsentsByUserIds(logins);
        log.debug("User data for login [{}] was removed from CMS.", (Object)logins);
        log.info("TPP [{}] was removed.", (Object)tppId);
        return ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).build();
    }

    public ResponseEntity<Void> removeAllTestData() throws InterruptedException {
        long start = System.currentTimeMillis();
        ResponseEntity response = this.adminRestClient.users(null, null, null, null, UserRoleTO.STAFF, null, 0, 9999);
        if (response != null && response.getBody() != null) {
            List content = ((CustomPageImpl)response.getBody()).getContent();
            List collect = content.stream().filter(u -> u.getLogin().matches("[0-9]+")).collect(Collectors.toList());
            Set ids = collect.stream().map(UserTO::getId).collect(Collectors.toSet());
            int count = 0;
            for (String id : ids) {
                this.remove(id);
                if (count % 20 == 0) {
                    Thread.sleep(1000L);
                }
                ++count;
            }
            log.info("Deletion of test TPPs is completed: {} items, in {}ms", (Object)ids.size(), (Object)(System.currentTimeMillis() - start));
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).build();
    }

    public ResponseEntity<Void> updatePassword(String tppId, String password) {
        return this.adminRestClient.updatePassword(tppId, password);
    }

    public ResponseEntity<Boolean> changeStatus(String userId) {
        return this.adminRestClient.changeStatus(userId);
    }

    public TppAdminController(UserMapper userMapper, DataRestClient dataRestClient, AdminRestClient adminRestClient, UserMgmtStaffRestClient userMgmtStaffRestClient, CmsDbNativeService cmsDbNativeService) {
        this.userMapper = userMapper;
        this.dataRestClient = dataRestClient;
        this.adminRestClient = adminRestClient;
        this.userMgmtStaffRestClient = userMgmtStaffRestClient;
        this.cmsDbNativeService = cmsDbNativeService;
    }
}

