/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.controller;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReportTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.client.rest.AccountMgmtStaffRestClient;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtStaffRestClient;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.AccountAccess;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.AccountReport;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.DepositAccount;
import de.adorsys.psd2.sandbox.tpp.rest.api.resource.TppAccountsRestApi;
import de.adorsys.psd2.sandbox.tpp.rest.server.mapper.AccountMapper;
import de.adorsys.psd2.sandbox.tpp.rest.server.service.DownloadResourceService;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tpp/accounts"})
public class TppAccountsController
implements TppAccountsRestApi {
    private static final String FILE_NAME = "data_payload_template.yml";
    private final AccountMapper accountMapper;
    private final AccountMgmtStaffRestClient accountMgmtStaffRestClient;
    private final UserMgmtStaffRestClient userMgmtStaffRestClient;
    private final DownloadResourceService downloadResourceService;

    public ResponseEntity<Void> createAccount(String userId, DepositAccount account) {
        return this.accountMgmtStaffRestClient.createDepositAccountForUser(userId, this.accountMapper.toAccountDetailsTO(account));
    }

    public ResponseEntity<Void> updateAccountAccess(AccountAccess accountAccess) {
        return this.userMgmtStaffRestClient.updateAccountAccessForUser(accountAccess.getId(), this.accountMapper.toAccountAccessTO(accountAccess));
    }

    public ResponseEntity<List<AccountDetailsTO>> getAllAccounts() {
        return this.accountMgmtStaffRestClient.getListOfAccounts();
    }

    public ResponseEntity<CustomPageImpl<AccountDetailsTO>> getAllAccounts(String queryParam, int page, int size) {
        return this.accountMgmtStaffRestClient.getListOfAccountsPaged(queryParam, page, size);
    }

    public ResponseEntity<AccountDetailsTO> getSingleAccount(String accountId) {
        return this.accountMgmtStaffRestClient.getAccountDetailsById(accountId);
    }

    public ResponseEntity<AccountReport> accountReport(String accountId) {
        return ResponseEntity.ok((Object)this.accountMapper.toAccountReport((AccountReportTO)this.accountMgmtStaffRestClient.getExtendedAccountDetailsById(accountId).getBody()));
    }

    public ResponseEntity<Void> depositCash(String accountId, AmountTO amount) {
        return this.accountMgmtStaffRestClient.depositCash(accountId, amount);
    }

    public ResponseEntity<Resource> downloadAccountTemplate() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).header("Content-Disposition", new String[]{"attachment; filename=data_payload_template.yml"})).body((Object)this.downloadResourceService.getResourceByTemplate(FILE_NAME));
    }

    public ResponseEntity<Boolean> changeStatus(String accountId) {
        return this.accountMgmtStaffRestClient.changeStatus(accountId);
    }

    public ResponseEntity<Void> updateCreditLimit(String accountId, BigDecimal creditAmount) {
        return this.accountMgmtStaffRestClient.changeCreditLimit(accountId, creditAmount);
    }

    public TppAccountsController(AccountMapper accountMapper, AccountMgmtStaffRestClient accountMgmtStaffRestClient, UserMgmtStaffRestClient userMgmtStaffRestClient, DownloadResourceService downloadResourceService) {
        this.accountMapper = accountMapper;
        this.accountMgmtStaffRestClient = accountMgmtStaffRestClient;
        this.userMgmtStaffRestClient = userMgmtStaffRestClient;
        this.downloadResourceService = downloadResourceService;
    }
}

