/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.config;

import de.adorsys.psd2.sandbox.auth.EnableSandboxSecurityFilter;
import de.adorsys.psd2.sandbox.auth.filter.LoginAuthenticationFilter;
import de.adorsys.psd2.sandbox.auth.filter.RefreshTokenFilter;
import de.adorsys.psd2.sandbox.auth.filter.TokenAuthenticationFilter;
import de.adorsys.psd2.sandbox.tpp.rest.server.auth.DisableEndpointFilter;
import de.adorsys.psd2.sandbox.tpp.rest.server.config.PermittedResources;
import javax.servlet.Filter;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

@EnableSandboxSecurityFilter
@Configuration
@EnableWebSecurity
public class TppWebSecurityConfig
extends WebSecurityConfigurerAdapter {
    private final LoginAuthenticationFilter loginAuthenticationFilter;
    private final RefreshTokenFilter refreshTokenFilter;
    private final Environment environment;
    private final TokenAuthenticationFilter tokenAuthenticationFilter;

    protected void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().antMatchers(PermittedResources.INDEX_WHITELIST)).permitAll().and()).authorizeRequests().antMatchers(PermittedResources.APP_WHITELIST)).permitAll().and()).authorizeRequests().antMatchers(PermittedResources.ACTUATOR_WHITELIST)).permitAll().and()).authorizeRequests().antMatchers(PermittedResources.SWAGGER_WHITELIST)).permitAll().and()).cors().and()).authorizeRequests().anyRequest()).authenticated();
        http.headers().frameOptions().disable();
        http.httpBasic().disable();
        http.addFilterBefore((Filter)new DisableEndpointFilter(this.environment), BasicAuthenticationFilter.class);
        http.addFilterBefore((Filter)this.loginAuthenticationFilter, BasicAuthenticationFilter.class);
        http.addFilterBefore((Filter)this.refreshTokenFilter, BasicAuthenticationFilter.class);
        http.addFilterBefore((Filter)this.tokenAuthenticationFilter, BasicAuthenticationFilter.class);
    }

    public TppWebSecurityConfig(LoginAuthenticationFilter loginAuthenticationFilter, RefreshTokenFilter refreshTokenFilter, Environment environment, TokenAuthenticationFilter tokenAuthenticationFilter) {
        this.loginAuthenticationFilter = loginAuthenticationFilter;
        this.refreshTokenFilter = refreshTokenFilter;
        this.environment = environment;
        this.tokenAuthenticationFilter = tokenAuthenticationFilter;
    }
}

