/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.service;

import de.adorsys.ledgers.middleware.api.domain.account.AccountBalanceTO;
import de.adorsys.ledgers.middleware.api.domain.general.RecoveryPointTO;
import de.adorsys.ledgers.middleware.api.domain.general.RevertRequestTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.um.UploadedDataTO;
import de.adorsys.ledgers.middleware.client.mappers.PaymentMapperTO;
import de.adorsys.ledgers.middleware.client.rest.DataRestClient;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtStaffRestClient;
import de.adorsys.psd2.sandbox.tpp.cms.api.service.CmsDbNativeService;
import de.adorsys.psd2.sandbox.tpp.rest.server.exception.TppException;
import de.adorsys.psd2.sandbox.tpp.rest.server.mapper.BalanceMapper;
import de.adorsys.psd2.sandbox.tpp.rest.server.model.AccountBalance;
import de.adorsys.psd2.sandbox.tpp.rest.server.model.DataPayload;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RestExecutionService {
    private static final Logger log = LoggerFactory.getLogger(RestExecutionService.class);
    private final DataRestClient dataRestClient;
    private final BalanceMapper balanceMapper;
    private final PaymentMapperTO paymentTOMapper;
    private final UserMgmtStaffRestClient userMgmtStaffRestClient;
    private final CmsDbNativeService cmsDbNativeService;

    public void updateLedgers(DataPayload payload) {
        if (!payload.isValidPayload()) {
            throw new TppException("Payload data is invalid", 400);
        }
        this.dataRestClient.uploadData(this.initialiseDataSets(payload));
    }

    public void revert(RevertRequestTO revertRequest) {
        List logins = (List)this.userMgmtStaffRestClient.getBranchUserLogins().getBody();
        RecoveryPointTO point = (RecoveryPointTO)this.dataRestClient.getPoint(Long.valueOf(revertRequest.getRecoveryPointId())).getBody();
        this.userMgmtStaffRestClient.revertDatabase(revertRequest);
        this.cmsDbNativeService.revertDatabase(logins, point.getRollBackTime());
    }

    private UploadedDataTO initialiseDataSets(DataPayload payload) {
        List paymentTOs = payload.getPayments().stream().map(arg_0 -> this.performMapping(arg_0)).collect(Collectors.toList());
        return new UploadedDataTO(payload.getUsers(), payload.getAccountByIban(), this.toAccountBalanceTO(payload.getBalancesByIban()), paymentTOs, payload.isGeneratePayments(), payload.getBranch());
    }

    private PaymentTO performMapping(PaymentTO payment) {
        String paymentString = this.paymentTOMapper.getMapper().writeValueAsString((Object)payment);
        return this.paymentTOMapper.toAbstractPayment(paymentString, "SINGLE", payment.getPaymentProduct());
    }

    private Map<String, AccountBalanceTO> toAccountBalanceTO(Map<String, AccountBalance> balancesByIban) {
        return balancesByIban.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.balanceMapper.toAccountBalanceTO((AccountBalance)e.getValue())));
    }

    public RestExecutionService(DataRestClient dataRestClient, BalanceMapper balanceMapper, PaymentMapperTO paymentTOMapper, UserMgmtStaffRestClient userMgmtStaffRestClient, CmsDbNativeService cmsDbNativeService) {
        this.dataRestClient = dataRestClient;
        this.balanceMapper = balanceMapper;
        this.paymentTOMapper = paymentTOMapper;
        this.userMgmtStaffRestClient = userMgmtStaffRestClient;
        this.cmsDbNativeService = cmsDbNativeService;
    }
}

