/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.model;

import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.psd2.sandbox.tpp.rest.server.exception.TppException;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.iban4j.CountryCode;
import org.iban4j.Iban;

public class TppData {
    private CountryCode countryCode;
    private String branchId;
    private long nextAccountNumber;

    public TppData(UserTO user) {
        if (user == null || StringUtils.isEmpty((CharSequence)user.getBranch()) || user.getAccountAccesses() == null) {
            throw new TppException("Could not retrieve tpp data", 400);
        }
        String[] countryCodeAndBranchId = user.getBranch().split("_");
        this.countryCode = CountryCode.valueOf((String)countryCodeAndBranchId[0]);
        this.branchId = countryCodeAndBranchId[1];
        this.nextAccountNumber = user.getAccountAccesses().stream().map(AccountAccessTO::getIban).map(Iban::valueOf).map(Iban::getAccountNumber).map(Long::parseLong).max(Comparator.comparingLong(Long::longValue)).map(i -> {
            i = i + 1L;
            return i;
        }).orElse(100L);
    }

    public static Map<CountryCode, String> sortMapByValue(Map<CountryCode, String> map) {
        return map.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    public CountryCode getCountryCode() {
        return this.countryCode;
    }

    public String getBranchId() {
        return this.branchId;
    }

    public long getNextAccountNumber() {
        return this.nextAccountNumber;
    }

    public void setCountryCode(CountryCode countryCode) {
        this.countryCode = countryCode;
    }

    public void setBranchId(String branchId) {
        this.branchId = branchId;
    }

    public void setNextAccountNumber(long nextAccountNumber) {
        this.nextAccountNumber = nextAccountNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TppData)) {
            return false;
        }
        TppData other = (TppData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        CountryCode this$countryCode = this.getCountryCode();
        CountryCode other$countryCode = other.getCountryCode();
        if (this$countryCode == null ? other$countryCode != null : !this$countryCode.equals(other$countryCode)) {
            return false;
        }
        String this$branchId = this.getBranchId();
        String other$branchId = other.getBranchId();
        if (this$branchId == null ? other$branchId != null : !this$branchId.equals(other$branchId)) {
            return false;
        }
        return this.getNextAccountNumber() == other.getNextAccountNumber();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TppData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CountryCode $countryCode = this.getCountryCode();
        result = result * 59 + ($countryCode == null ? 43 : $countryCode.hashCode());
        String $branchId = this.getBranchId();
        result = result * 59 + ($branchId == null ? 43 : $branchId.hashCode());
        long $nextAccountNumber = this.getNextAccountNumber();
        result = result * 59 + (int)($nextAccountNumber >>> 32 ^ $nextAccountNumber);
        return result;
    }

    public String toString() {
        return "TppData(countryCode=" + this.getCountryCode() + ", branchId=" + this.getBranchId() + ", nextAccountNumber=" + this.getNextAccountNumber() + ")";
    }
}

