/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.mapper;

import de.adorsys.psd2.sandbox.tpp.db.api.domain.OperationInfoEntity;
import de.adorsys.psd2.sandbox.tpp.db.api.domain.OperationTypeEntity;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.OperationInfo;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.OperationType;
import de.adorsys.psd2.sandbox.tpp.rest.server.mapper.OperationInfoMapper;
import de.adorsys.psd2.sandbox.tpp.rest.server.mapper.OperationInfoMapperImpl;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class OperationInfoMapperImpl
implements OperationInfoMapper {
    public OperationInfo toOperationInfo(OperationInfoEntity source) {
        if (source == null) {
            return null;
        }
        OperationInfo operationInfo = new OperationInfo();
        operationInfo.setId(source.getId());
        operationInfo.setOperationType(this.operationTypeEntityToOperationType(source.getOperationType()));
        operationInfo.setEncryptedOperationId(source.getEncryptedOperationId());
        operationInfo.setTppId(source.getTppId());
        operationInfo.setCreated(source.getCreated());
        return operationInfo;
    }

    public List<OperationInfo> toOperationInfos(List<OperationInfoEntity> source) {
        if (source == null) {
            return null;
        }
        ArrayList<OperationInfo> list = new ArrayList<OperationInfo>(source.size());
        for (OperationInfoEntity operationInfoEntity : source) {
            list.add(this.toOperationInfo(operationInfoEntity));
        }
        return list;
    }

    public OperationInfoEntity toOperationInfoEntity(OperationInfo source) {
        if (source == null) {
            return null;
        }
        OperationInfoEntity operationInfoEntity = new OperationInfoEntity();
        operationInfoEntity.setId(source.getId());
        operationInfoEntity.setOperationType(this.operationTypeToOperationTypeEntity(source.getOperationType()));
        operationInfoEntity.setEncryptedOperationId(source.getEncryptedOperationId());
        operationInfoEntity.setTppId(source.getTppId());
        operationInfoEntity.setCreated(source.getCreated());
        return operationInfoEntity;
    }

    protected OperationType operationTypeEntityToOperationType(OperationTypeEntity operationTypeEntity) {
        OperationType operationType;
        if (operationTypeEntity == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$psd2$sandbox$tpp$db$api$domain$OperationTypeEntity[operationTypeEntity.ordinal()]) {
            case 1: {
                operationType = OperationType.PAYMENT;
                break;
            }
            case 2: {
                operationType = OperationType.CONSENT;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + operationTypeEntity);
            }
        }
        return operationType;
    }

    protected OperationTypeEntity operationTypeToOperationTypeEntity(OperationType operationType) {
        OperationTypeEntity operationTypeEntity;
        if (operationType == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$psd2$sandbox$tpp$rest$api$domain$OperationType[operationType.ordinal()]) {
            case 1: {
                operationTypeEntity = OperationTypeEntity.PAYMENT;
                break;
            }
            case 2: {
                operationTypeEntity = OperationTypeEntity.CONSENT;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + operationType);
            }
        }
        return operationTypeEntity;
    }
}

