/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.controller;

import de.adorsys.psd2.sandbox.tpp.rest.api.domain.OperationInfo;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.OperationType;
import de.adorsys.psd2.sandbox.tpp.rest.api.resource.TppOperationInfoRestApi;
import de.adorsys.psd2.sandbox.tpp.rest.server.service.TppOperationInfoService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tpp/operation"})
public class TppOperationInfoController
implements TppOperationInfoRestApi {
    private static final Logger log = LoggerFactory.getLogger(TppOperationInfoController.class);
    private final TppOperationInfoService infoService;

    public ResponseEntity<List<OperationInfo>> getAllOperations(OperationType operationType) {
        return ResponseEntity.ok((Object)this.infoService.getOperationsByTypeAndTppId(operationType));
    }

    public ResponseEntity<OperationInfo> addOperationInfo(OperationInfo operationInfo) {
        return ResponseEntity.ok((Object)this.infoService.createInfo(operationInfo));
    }

    public ResponseEntity<Void> deleteOperationInfo(Long operationInfoId) {
        this.infoService.deleteInfo(operationInfoId);
        return ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).build();
    }

    public TppOperationInfoController(TppOperationInfoService infoService) {
        this.infoService = infoService;
    }
}

