/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.auth;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class DisableEndpointFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(DisableEndpointFilter.class);
    private static final Map<String, Pair<String, String>> DISABLED_MAP;
    private static final AntPathMatcher matcher;
    private final Environment env;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String u2;
        Pair o;
        Optional<String> isDisabled = DISABLED_MAP.keySet().stream().filter(u -> matcher.match(request.getServletPath(), u)).findFirst();
        if (isDisabled.isPresent() && this.isDisabled((String)(o = (Pair)DISABLED_MAP.get(u2 = isDisabled.get())).getKey())) {
            String msg = Optional.ofNullable((String)o.getValue()).orElse("This feature is Disabled by Administration!");
            response.sendError(HttpStatus.FORBIDDEN.value(), msg);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean isDisabled(String property) {
        return StringUtils.isBlank((CharSequence)property) || Optional.ofNullable((Boolean)this.env.getProperty(property, Boolean.class)).orElse(false) != false;
    }

    public DisableEndpointFilter(Environment env) {
        this.env = env;
    }

    static {
        matcher = new AntPathMatcher();
        DISABLED_MAP = Map.of("/tpp/register", Pair.of((Object)"app.endpoints.tpp.self.registration.disabled", (Object)"Self Registration is Disabled by Administration."));
    }
}

