/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.service;

import de.adorsys.ledgers.middleware.client.rest.MockTransactionsStaffRestClient;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.UserTransaction;
import de.adorsys.psd2.sandbox.tpp.rest.server.mapper.MockTransactionDataConverter;
import de.adorsys.psd2.sandbox.tpp.rest.server.service.ParseService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TransactionService {
    private static final Logger log = LoggerFactory.getLogger(TransactionService.class);
    private final ParseService parseService;
    private final MockTransactionsStaffRestClient transactionsStaffRestClient;
    private final MockTransactionDataConverter transactionDataConverter;

    public Map<String, String> uploadUserTransaction(MultipartFile multipart) {
        log.info("parsing transaction data");
        List transactions = this.parseService.convertFileToTargetObject(multipart, UserTransaction.class);
        log.info("{} transactions parsed", (Object)transactions.size());
        Map map = (Map)this.transactionsStaffRestClient.transactions(this.transactionDataConverter.toLedgersMockTransactions(transactions)).getBody();
        log.info("Call to Ledgers to create new transactions successful");
        return map;
    }

    public TransactionService(ParseService parseService, MockTransactionsStaffRestClient transactionsStaffRestClient, MockTransactionDataConverter transactionDataConverter) {
        this.parseService = parseService;
        this.transactionsStaffRestClient = transactionsStaffRestClient;
        this.transactionDataConverter = transactionDataConverter;
    }
}

