/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.mapper;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReportTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountStatusTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountTypeTO;
import de.adorsys.ledgers.middleware.api.domain.account.UsageTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.AccessType;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.AccountAccess;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.AccountReport;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.AccountStatus;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.AccountType;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.AccountUsage;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.DepositAccount;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.UserAccess;
import de.adorsys.psd2.sandbox.tpp.rest.server.mapper.AccountMapper;
import de.adorsys.psd2.sandbox.tpp.rest.server.mapper.AccountMapperImpl;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class AccountMapperImpl
implements AccountMapper {
    public AccountDetailsTO toAccountDetailsTO(DepositAccount depositAccount) {
        if (depositAccount == null) {
            return null;
        }
        AccountDetailsTO accountDetailsTO = new AccountDetailsTO();
        accountDetailsTO.setIban(depositAccount.getIban());
        accountDetailsTO.setCurrency(depositAccount.getCurrency());
        accountDetailsTO.setAccountType(this.accountTypeToAccountTypeTO(depositAccount.getAccountType()));
        accountDetailsTO.setAccountStatus(this.accountStatusToAccountStatusTO(depositAccount.getAccountStatus()));
        accountDetailsTO.setUsageType(this.accountUsageToUsageTypeTO(depositAccount.getUsageType()));
        return accountDetailsTO;
    }

    public AccountAccessTO toAccountAccessTO(AccountAccess accountAccess) {
        if (accountAccess == null) {
            return null;
        }
        AccountAccessTO accountAccessTO = new AccountAccessTO();
        accountAccessTO.setIban(accountAccess.getIban());
        accountAccessTO.setCurrency(accountAccess.getCurrency());
        accountAccessTO.setAccessType(accountAccess.getAccessType());
        accountAccessTO.setScaWeight(accountAccess.getScaWeight());
        accountAccessTO.setAccountId(accountAccess.getAccountId());
        return accountAccessTO;
    }

    public AccountReport toAccountReport(AccountReportTO report) {
        if (report == null) {
            return null;
        }
        AccountReport accountReport = new AccountReport();
        accountReport.setAccesses(this.toUserAccesses(report.getUsersAccessingAccount()));
        accountReport.setDetails(report.getDetails());
        return accountReport;
    }

    public List<UserAccess> toUserAccesses(List<UserTO> users) {
        if (users == null) {
            return null;
        }
        ArrayList<UserAccess> list = new ArrayList<UserAccess>(users.size());
        for (UserTO userTO : users) {
            list.add(this.toUserAccess(userTO));
        }
        return list;
    }

    public UserAccess toUserAccess(UserTO user) {
        if (user == null) {
            return null;
        }
        UserAccess userAccess = new UserAccess();
        userAccess.setUserLogin(user.getLogin());
        userAccess.setScaWeight(((AccountAccessTO)user.getAccountAccesses().get(0)).getScaWeight());
        userAccess.setAccessType(this.toAccessType(((AccountAccessTO)user.getAccountAccesses().get(0)).getAccessType()));
        return userAccess;
    }

    public AccessType toAccessType(AccessTypeTO accessTypeTO) {
        AccessType accessType;
        if (accessTypeTO == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$ledgers$middleware$api$domain$um$AccessTypeTO[accessTypeTO.ordinal()]) {
            case 1: {
                accessType = AccessType.OWNER;
                break;
            }
            case 2: {
                accessType = AccessType.READ;
                break;
            }
            case 3: {
                accessType = AccessType.DISPOSE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + accessTypeTO);
            }
        }
        return accessType;
    }

    protected AccountTypeTO accountTypeToAccountTypeTO(AccountType accountType) {
        AccountTypeTO accountTypeTO;
        if (accountType == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$psd2$sandbox$tpp$rest$api$domain$AccountType[accountType.ordinal()]) {
            case 1: {
                accountTypeTO = AccountTypeTO.CACC;
                break;
            }
            case 2: {
                accountTypeTO = AccountTypeTO.CASH;
                break;
            }
            case 3: {
                accountTypeTO = AccountTypeTO.CHAR;
                break;
            }
            case 4: {
                accountTypeTO = AccountTypeTO.CISH;
                break;
            }
            case 5: {
                accountTypeTO = AccountTypeTO.COMM;
                break;
            }
            case 6: {
                accountTypeTO = AccountTypeTO.CPAC;
                break;
            }
            case 7: {
                accountTypeTO = AccountTypeTO.LLSV;
                break;
            }
            case 8: {
                accountTypeTO = AccountTypeTO.LOAN;
                break;
            }
            case 9: {
                accountTypeTO = AccountTypeTO.MGLD;
                break;
            }
            case 10: {
                accountTypeTO = AccountTypeTO.MOMA;
                break;
            }
            case 11: {
                accountTypeTO = AccountTypeTO.NREX;
                break;
            }
            case 12: {
                accountTypeTO = AccountTypeTO.ODFT;
                break;
            }
            case 13: {
                accountTypeTO = AccountTypeTO.ONDP;
                break;
            }
            case 14: {
                accountTypeTO = AccountTypeTO.OTHR;
                break;
            }
            case 15: {
                accountTypeTO = AccountTypeTO.SACC;
                break;
            }
            case 16: {
                accountTypeTO = AccountTypeTO.SLRY;
                break;
            }
            case 17: {
                accountTypeTO = AccountTypeTO.SVGS;
                break;
            }
            case 18: {
                accountTypeTO = AccountTypeTO.TAXE;
                break;
            }
            case 19: {
                accountTypeTO = AccountTypeTO.TRAN;
                break;
            }
            case 20: {
                accountTypeTO = AccountTypeTO.TRAS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + accountType);
            }
        }
        return accountTypeTO;
    }

    protected AccountStatusTO accountStatusToAccountStatusTO(AccountStatus accountStatus) {
        AccountStatusTO accountStatusTO;
        if (accountStatus == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$psd2$sandbox$tpp$rest$api$domain$AccountStatus[accountStatus.ordinal()]) {
            case 1: {
                accountStatusTO = AccountStatusTO.ENABLED;
                break;
            }
            case 2: {
                accountStatusTO = AccountStatusTO.DELETED;
                break;
            }
            case 3: {
                accountStatusTO = AccountStatusTO.BLOCKED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + accountStatus);
            }
        }
        return accountStatusTO;
    }

    protected UsageTypeTO accountUsageToUsageTypeTO(AccountUsage accountUsage) {
        UsageTypeTO usageTypeTO;
        if (accountUsage == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$psd2$sandbox$tpp$rest$api$domain$AccountUsage[accountUsage.ordinal()]) {
            case 1: {
                usageTypeTO = UsageTypeTO.PRIV;
                break;
            }
            case 2: {
                usageTypeTO = UsageTypeTO.ORGA;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + accountUsage);
            }
        }
        return usageTypeTO;
    }
}

