/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.controller;

import de.adorsys.ledgers.middleware.api.domain.general.BbanStructure;
import de.adorsys.ledgers.middleware.api.domain.general.RevertRequestTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.client.rest.DataRestClient;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtRestClient;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtStaffRestClient;
import de.adorsys.psd2.sandbox.tpp.cms.api.service.CmsDbNativeService;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.BankCodeStructure;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.User;
import de.adorsys.psd2.sandbox.tpp.rest.api.resource.TppRestApi;
import de.adorsys.psd2.sandbox.tpp.rest.server.mapper.UserMapper;
import de.adorsys.psd2.sandbox.tpp.rest.server.service.IbanGenerationService;
import de.adorsys.psd2.sandbox.tpp.rest.server.service.RestExecutionService;
import java.util.Currency;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.iban4j.CountryCode;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tpp"})
public class TppController
implements TppRestApi {
    private final UserMapper userMapper;
    private final UserMgmtStaffRestClient userMgmtStaffRestClient;
    private final UserMgmtRestClient userMgmtRestClient;
    private final DataRestClient dataRestClient;
    private final IbanGenerationService ibanGenerationService;
    private final CmsDbNativeService cmsDbNativeService;
    private final RestExecutionService restExecutionService;

    public void login(String login, String pin) {
    }

    public ResponseEntity<Set<Currency>> getCurrencies() {
        return this.dataRestClient.currencies();
    }

    public ResponseEntity<Map<CountryCode, String>> getSupportedCountryCodes() {
        return ResponseEntity.ok((Object)this.ibanGenerationService.getCountryCodes());
    }

    public ResponseEntity<BankCodeStructure> getBankCodeStructure(String countryCode) {
        return ResponseEntity.ok((Object)this.ibanGenerationService.getBankCodeStructure(CountryCode.valueOf((String)countryCode)));
    }

    public ResponseEntity<String> getRandomTppId(String countryCode) {
        BankCodeStructure structure = new BankCodeStructure(CountryCode.getByCode((String)countryCode));
        BbanStructure bbanStructure = new BbanStructure();
        bbanStructure.setCountryPrefix(structure.getCountryCode().name());
        bbanStructure.setLength(structure.getLength());
        bbanStructure.setEntryType(BbanStructure.EntryType.valueOf((String)structure.getType().name().toUpperCase()));
        return this.dataRestClient.branchId(bbanStructure);
    }

    public ResponseEntity<Void> register(User user) {
        UserTO userTO = this.userMapper.toUserTO(user);
        this.userMgmtStaffRestClient.register(user.getId(), userTO);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }

    public ResponseEntity<Void> remove() {
        List logins = (List)this.userMgmtStaffRestClient.getBranchUserLogins().getBody();
        this.cmsDbNativeService.deleteConsentsByUserIds(logins);
        UserTO user = (UserTO)this.userMgmtRestClient.getUser().getBody();
        return this.dataRestClient.branch(user.getBranch());
    }

    public ResponseEntity<Void> transactions(String accountId) {
        return this.dataRestClient.account(accountId);
    }

    public ResponseEntity<Void> account(String accountId) {
        return this.dataRestClient.depositAccount(accountId);
    }

    public ResponseEntity<Void> user(String userId) {
        return this.dataRestClient.user(userId);
    }

    public ResponseEntity<Void> revert(RevertRequestTO revertRequest) {
        this.restExecutionService.revert(revertRequest);
        return ResponseEntity.status((HttpStatus)HttpStatus.ACCEPTED).build();
    }

    public TppController(UserMapper userMapper, UserMgmtStaffRestClient userMgmtStaffRestClient, UserMgmtRestClient userMgmtRestClient, DataRestClient dataRestClient, IbanGenerationService ibanGenerationService, CmsDbNativeService cmsDbNativeService, RestExecutionService restExecutionService) {
        this.userMapper = userMapper;
        this.userMgmtStaffRestClient = userMgmtStaffRestClient;
        this.userMgmtRestClient = userMgmtRestClient;
        this.dataRestClient = dataRestClient;
        this.ibanGenerationService = ibanGenerationService;
        this.cmsDbNativeService = cmsDbNativeService;
        this.restExecutionService = restExecutionService;
    }
}

