/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import de.adorsys.psd2.sandbox.tpp.cms.api.service.ConsentService;
import de.adorsys.psd2.sandbox.tpp.rest.api.resource.TppConsentRestApi;
import de.adorsys.psd2.sandbox.tpp.rest.server.exception.TppException;
import de.adorsys.psd2.sandbox.tpp.rest.server.service.DownloadResourceService;
import de.adorsys.psd2.sandbox.tpp.rest.server.service.ParseService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/tpp/consent"})
public class TppConsentController
implements TppConsentRestApi {
    private static final Logger log = LoggerFactory.getLogger(TppConsentController.class);
    private static final String FILE_NAME = "consents_template.yml";
    private final ConsentService tppConsentService;
    private final DownloadResourceService downloadResourceService;
    private final ParseService parseService;

    public ResponseEntity<List<String>> generateConsents(MultipartFile file) {
        log.info("Update file received");
        List parsed = (List)this.parseService.getDataFromFile(file, (TypeReference)new /* Unavailable Anonymous Inner Class!! */).orElseThrow(() -> new TppException("Could not parse data", 400));
        return ResponseEntity.ok((Object)this.tppConsentService.generateConsents(parsed));
    }

    public ResponseEntity<Resource> downloadConsentTemplate() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).header("Content-Disposition", new String[]{"attachment; filename=consents_template.yml"})).body((Object)this.downloadResourceService.getResourceByTemplate(FILE_NAME));
    }

    public TppConsentController(ConsentService tppConsentService, DownloadResourceService downloadResourceService, ParseService parseService) {
        this.tppConsentService = tppConsentService;
        this.downloadResourceService = downloadResourceService;
        this.parseService = parseService;
    }
}

