/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.controller;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsExtendedTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserExtendedTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.client.rest.AdminRestClient;
import de.adorsys.ledgers.middleware.client.rest.DataRestClient;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.User;
import de.adorsys.psd2.sandbox.tpp.rest.api.resource.TppAdminRestApi;
import de.adorsys.psd2.sandbox.tpp.rest.server.mapper.UserMapper;
import java.util.Collections;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tpp/admin"})
public class TppAdminController
implements TppAdminRestApi {
    private final UserMapper userMapper;
    private final DataRestClient dataRestClient;
    private final AdminRestClient adminRestClient;

    public ResponseEntity<CustomPageImpl<UserExtendedTO>> users(String countryCode, String tppId, String tppLogin, String userLogin, UserRoleTO role, Boolean blocked, int page, int size) {
        return this.adminRestClient.users(countryCode, tppId, tppLogin, userLogin, role, blocked, page, size);
    }

    public ResponseEntity<Void> user(UserTO user) {
        return this.adminRestClient.user(user);
    }

    public ResponseEntity<CustomPageImpl<AccountDetailsExtendedTO>> accounts(String countryCode, String tppId, String tppLogin, String ibanParam, Boolean isBlocked, int page, int size) {
        return this.adminRestClient.accounts(countryCode, tppId, tppLogin, ibanParam, isBlocked, page, size);
    }

    public ResponseEntity<Void> register(User user, String tppId) {
        UserTO userTO = this.userMapper.toUserTO(user);
        if (userTO.getUserRoles().contains(UserRoleTO.CUSTOMER)) {
            userTO.setBranch(tppId);
        }
        this.adminRestClient.register(userTO);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }

    public ResponseEntity<Void> admin(User user) {
        UserTO userTO = this.userMapper.toUserTO(user);
        userTO.setUserRoles(Collections.singletonList(UserRoleTO.SYSTEM));
        this.adminRestClient.register(userTO);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }

    public ResponseEntity<CustomPageImpl<UserTO>> admins(int page, int size) {
        return this.adminRestClient.admins(page, size);
    }

    public ResponseEntity<Void> remove(String tppId) {
        return this.dataRestClient.branch(tppId);
    }

    public ResponseEntity<Void> updatePassword(String tppId, String password) {
        return this.adminRestClient.updatePassword(tppId, password);
    }

    public ResponseEntity<Boolean> changeStatus(String userId) {
        return this.adminRestClient.changeStatus(userId);
    }

    public TppAdminController(UserMapper userMapper, DataRestClient dataRestClient, AdminRestClient adminRestClient) {
        this.userMapper = userMapper;
        this.dataRestClient = dataRestClient;
        this.adminRestClient = adminRestClient;
    }
}

