package de.adorsys.psd2.sandbox.tpp.rest.server.mapper;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReportTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountStatusTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountTypeTO;
import de.adorsys.ledgers.middleware.api.domain.account.UsageTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.AccessType;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.AccountAccess;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.AccountReport;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.AccountStatus;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.AccountType;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.AccountUsage;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.DepositAccount;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.UserAccess;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-05-26T09:28:40+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 11.0.2 (Oracle Corporation)"
)
@Component
public class AccountMapperImpl implements AccountMapper {

    @Override
    public AccountDetailsTO toAccountDetailsTO(DepositAccount depositAccount) {
        if ( depositAccount == null ) {
            return null;
        }

        AccountDetailsTO accountDetailsTO = new AccountDetailsTO();

        accountDetailsTO.setIban( depositAccount.getIban() );
        accountDetailsTO.setCurrency( depositAccount.getCurrency() );
        accountDetailsTO.setAccountType( accountTypeToAccountTypeTO( depositAccount.getAccountType() ) );
        accountDetailsTO.setAccountStatus( accountStatusToAccountStatusTO( depositAccount.getAccountStatus() ) );
        accountDetailsTO.setUsageType( accountUsageToUsageTypeTO( depositAccount.getUsageType() ) );

        return accountDetailsTO;
    }

    @Override
    public AccountAccessTO toAccountAccessTO(AccountAccess accountAccess) {
        if ( accountAccess == null ) {
            return null;
        }

        AccountAccessTO accountAccessTO = new AccountAccessTO();

        accountAccessTO.setIban( accountAccess.getIban() );
        accountAccessTO.setCurrency( accountAccess.getCurrency() );
        accountAccessTO.setAccessType( accountAccess.getAccessType() );
        accountAccessTO.setScaWeight( accountAccess.getScaWeight() );
        accountAccessTO.setAccountId( accountAccess.getAccountId() );

        return accountAccessTO;
    }

    @Override
    public AccountReport toAccountReport(AccountReportTO report) {
        if ( report == null ) {
            return null;
        }

        AccountReport accountReport = new AccountReport();

        accountReport.setAccesses( toUserAccesses( report.getUsersAccessingAccount() ) );
        accountReport.setDetails( report.getDetails() );

        return accountReport;
    }

    @Override
    public List<UserAccess> toUserAccesses(List<UserTO> users) {
        if ( users == null ) {
            return null;
        }

        List<UserAccess> list = new ArrayList<UserAccess>( users.size() );
        for ( UserTO userTO : users ) {
            list.add( toUserAccess( userTO ) );
        }

        return list;
    }

    @Override
    public UserAccess toUserAccess(UserTO user) {
        if ( user == null ) {
            return null;
        }

        UserAccess userAccess = new UserAccess();

        userAccess.setUserLogin( user.getLogin() );

        userAccess.setAccessType( toAccessType(user.getAccountAccesses().get(0).getAccessType()) );
        userAccess.setScaWeight( user.getAccountAccesses().get(0).getScaWeight() );

        return userAccess;
    }

    @Override
    public AccessType toAccessType(AccessTypeTO accessTypeTO) {
        if ( accessTypeTO == null ) {
            return null;
        }

        AccessType accessType;

        switch ( accessTypeTO ) {
            case OWNER: accessType = AccessType.OWNER;
            break;
            case READ: accessType = AccessType.READ;
            break;
            case DISPOSE: accessType = AccessType.DISPOSE;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + accessTypeTO );
        }

        return accessType;
    }

    protected AccountTypeTO accountTypeToAccountTypeTO(AccountType accountType) {
        if ( accountType == null ) {
            return null;
        }

        AccountTypeTO accountTypeTO;

        switch ( accountType ) {
            case CACC: accountTypeTO = AccountTypeTO.CACC;
            break;
            case CASH: accountTypeTO = AccountTypeTO.CASH;
            break;
            case CHAR: accountTypeTO = AccountTypeTO.CHAR;
            break;
            case CISH: accountTypeTO = AccountTypeTO.CISH;
            break;
            case COMM: accountTypeTO = AccountTypeTO.COMM;
            break;
            case CPAC: accountTypeTO = AccountTypeTO.CPAC;
            break;
            case LLSV: accountTypeTO = AccountTypeTO.LLSV;
            break;
            case LOAN: accountTypeTO = AccountTypeTO.LOAN;
            break;
            case MGLD: accountTypeTO = AccountTypeTO.MGLD;
            break;
            case MOMA: accountTypeTO = AccountTypeTO.MOMA;
            break;
            case NREX: accountTypeTO = AccountTypeTO.NREX;
            break;
            case ODFT: accountTypeTO = AccountTypeTO.ODFT;
            break;
            case ONDP: accountTypeTO = AccountTypeTO.ONDP;
            break;
            case OTHR: accountTypeTO = AccountTypeTO.OTHR;
            break;
            case SACC: accountTypeTO = AccountTypeTO.SACC;
            break;
            case SLRY: accountTypeTO = AccountTypeTO.SLRY;
            break;
            case SVGS: accountTypeTO = AccountTypeTO.SVGS;
            break;
            case TAXE: accountTypeTO = AccountTypeTO.TAXE;
            break;
            case TRAN: accountTypeTO = AccountTypeTO.TRAN;
            break;
            case TRAS: accountTypeTO = AccountTypeTO.TRAS;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + accountType );
        }

        return accountTypeTO;
    }

    protected AccountStatusTO accountStatusToAccountStatusTO(AccountStatus accountStatus) {
        if ( accountStatus == null ) {
            return null;
        }

        AccountStatusTO accountStatusTO;

        switch ( accountStatus ) {
            case ENABLED: accountStatusTO = AccountStatusTO.ENABLED;
            break;
            case DELETED: accountStatusTO = AccountStatusTO.DELETED;
            break;
            case BLOCKED: accountStatusTO = AccountStatusTO.BLOCKED;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + accountStatus );
        }

        return accountStatusTO;
    }

    protected UsageTypeTO accountUsageToUsageTypeTO(AccountUsage accountUsage) {
        if ( accountUsage == null ) {
            return null;
        }

        UsageTypeTO usageTypeTO;

        switch ( accountUsage ) {
            case PRIV: usageTypeTO = UsageTypeTO.PRIV;
            break;
            case ORGA: usageTypeTO = UsageTypeTO.ORGA;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + accountUsage );
        }

        return usageTypeTO;
    }
}
