package de.adorsys.psd2.sandbox.tpp.rest.server.mapper;

import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaMethodTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.AccountAccess;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.ScaMethodType;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.ScaUserData;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.User;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.UserRole;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-03-19T10:20:53+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 11.0.2 (Oracle Corporation)"
)
@Component
public class UserMapperImpl implements UserMapper {

    @Override
    public UserTO toUserTO(User user) {

        UserTO userTO = new UserTO();

        if ( user != null ) {
            userTO.setId( user.getId() );
            userTO.setLogin( user.getLogin() );
            userTO.setEmail( user.getEmail() );
            userTO.setPin( user.getPin() );
            userTO.setScaUserData( scaUserDataListToScaUserDataTOList( user.getScaUserData() ) );
            userTO.setAccountAccesses( accountAccessListToAccountAccessTOList( user.getAccountAccesses() ) );
            userTO.setUserRoles( userRoleListToUserRoleTOCollection( user.getUserRoles() ) );
        }

        return userTO;
    }

    protected ScaMethodTypeTO scaMethodTypeToScaMethodTypeTO(ScaMethodType scaMethodType) {
        if ( scaMethodType == null ) {
            return null;
        }

        ScaMethodTypeTO scaMethodTypeTO;

        switch ( scaMethodType ) {
            case EMAIL: scaMethodTypeTO = ScaMethodTypeTO.EMAIL;
            break;
            case MOBILE: scaMethodTypeTO = ScaMethodTypeTO.MOBILE;
            break;
            case CHIP_OTP: scaMethodTypeTO = ScaMethodTypeTO.CHIP_OTP;
            break;
            case PHOTO_OTP: scaMethodTypeTO = ScaMethodTypeTO.PHOTO_OTP;
            break;
            case PUSH_OTP: scaMethodTypeTO = ScaMethodTypeTO.PUSH_OTP;
            break;
            case SMS_OTP: scaMethodTypeTO = ScaMethodTypeTO.SMS_OTP;
            break;
            case APP_OTP: scaMethodTypeTO = ScaMethodTypeTO.APP_OTP;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + scaMethodType );
        }

        return scaMethodTypeTO;
    }

    protected ScaUserDataTO scaUserDataToScaUserDataTO(ScaUserData scaUserData) {

        ScaUserDataTO scaUserDataTO = new ScaUserDataTO();

        if ( scaUserData != null ) {
            scaUserDataTO.setId( scaUserData.getId() );
            scaUserDataTO.setScaMethod( scaMethodTypeToScaMethodTypeTO( scaUserData.getScaMethod() ) );
            scaUserDataTO.setMethodValue( scaUserData.getMethodValue() );
            scaUserDataTO.setUsesStaticTan( scaUserData.isUsesStaticTan() );
            scaUserDataTO.setStaticTan( scaUserData.getStaticTan() );
            scaUserDataTO.setDecoupled( scaUserData.isDecoupled() );
            scaUserDataTO.setValid( scaUserData.isValid() );
        }

        return scaUserDataTO;
    }

    protected List<ScaUserDataTO> scaUserDataListToScaUserDataTOList(List<ScaUserData> list) {
        if ( list == null ) {
            return new ArrayList<ScaUserDataTO>();
        }

        List<ScaUserDataTO> list1 = new ArrayList<ScaUserDataTO>( list.size() );
        for ( ScaUserData scaUserData : list ) {
            list1.add( scaUserDataToScaUserDataTO( scaUserData ) );
        }

        return list1;
    }

    protected AccountAccessTO accountAccessToAccountAccessTO(AccountAccess accountAccess) {

        AccountAccessTO accountAccessTO = new AccountAccessTO();

        if ( accountAccess != null ) {
            accountAccessTO.setId( accountAccess.getId() );
            accountAccessTO.setIban( accountAccess.getIban() );
            accountAccessTO.setCurrency( accountAccess.getCurrency() );
            accountAccessTO.setAccessType( accountAccess.getAccessType() );
            accountAccessTO.setScaWeight( accountAccess.getScaWeight() );
            accountAccessTO.setAccountId( accountAccess.getAccountId() );
        }

        return accountAccessTO;
    }

    protected List<AccountAccessTO> accountAccessListToAccountAccessTOList(List<AccountAccess> list) {
        if ( list == null ) {
            return new ArrayList<AccountAccessTO>();
        }

        List<AccountAccessTO> list1 = new ArrayList<AccountAccessTO>( list.size() );
        for ( AccountAccess accountAccess : list ) {
            list1.add( accountAccessToAccountAccessTO( accountAccess ) );
        }

        return list1;
    }

    protected UserRoleTO userRoleToUserRoleTO(UserRole userRole) {
        if ( userRole == null ) {
            return null;
        }

        UserRoleTO userRoleTO;

        switch ( userRole ) {
            case CUSTOMER: userRoleTO = UserRoleTO.CUSTOMER;
            break;
            case STAFF: userRoleTO = UserRoleTO.STAFF;
            break;
            case TECHNICAL: userRoleTO = UserRoleTO.TECHNICAL;
            break;
            case SYSTEM: userRoleTO = UserRoleTO.SYSTEM;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + userRole );
        }

        return userRoleTO;
    }

    protected Collection<UserRoleTO> userRoleListToUserRoleTOCollection(List<UserRole> list) {
        if ( list == null ) {
            return new ArrayList<UserRoleTO>();
        }

        Collection<UserRoleTO> collection = new ArrayList<UserRoleTO>( list.size() );
        for ( UserRole userRole : list ) {
            collection.add( userRoleToUserRoleTO( userRole ) );
        }

        return collection;
    }
}
