package de.adorsys.psd2.sandbox.tpp.rest.server.mapper;

import de.adorsys.ledgers.middleware.api.domain.account.MockBookingDetails;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.UserTransaction;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-03-19T10:20:53+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 11.0.2 (Oracle Corporation)"
)
@Component
public class MockTransactionDataConverterImpl implements MockTransactionDataConverter {

    @Override
    public List<MockBookingDetails> toLedgersMockTransactions(List<UserTransaction> transactions) {
        if ( transactions == null ) {
            return null;
        }

        List<MockBookingDetails> list = new ArrayList<MockBookingDetails>( transactions.size() );
        for ( UserTransaction userTransaction : transactions ) {
            list.add( toLedgersMockTransaction( userTransaction ) );
        }

        return list;
    }

    @Override
    public MockBookingDetails toLedgersMockTransaction(UserTransaction transaction) {
        if ( transaction == null ) {
            return null;
        }

        MockBookingDetails mockBookingDetails = new MockBookingDetails();

        mockBookingDetails.setOtherAccount( transaction.getAccountNumber() );
        mockBookingDetails.setUserAccount( transaction.getId() );
        mockBookingDetails.setCrDrName( transaction.getPayer() );
        mockBookingDetails.setBookingDate( toLocalDate( transaction.getPostingDate() ) );
        mockBookingDetails.setValueDate( toLocalDate( transaction.getValueDate() ) );
        mockBookingDetails.setRemittance( transaction.getUsage() );
        if ( transaction.getAmount() != null ) {
            mockBookingDetails.setAmount( new BigDecimal( transaction.getAmount() ) );
        }
        if ( transaction.getCurrency() != null ) {
            mockBookingDetails.setCurrency( Currency.getInstance( transaction.getCurrency() ) );
        }

        return mockBookingDetails;
    }
}
