/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.service;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.opencsv.bean.CsvToBean;
import com.opencsv.bean.CsvToBeanBuilder;
import de.adorsys.psd2.sandbox.tpp.rest.server.exception.TppException;
import de.adorsys.psd2.sandbox.tpp.rest.server.model.DataPayload;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ParseService {
    private static final Logger log = LoggerFactory.getLogger(ParseService.class);
    private static final String DEFAULT_TEMPLATE_YML = "classpath:NISP_Testing_Default_Template.yml";
    private static final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final ResourceLoader resourceLoader;

    public <T> Optional<T> getDataFromFile(MultipartFile input, TypeReference<T> typeReference) {
        try {
            return Optional.ofNullable(objectMapper.readValue(input.getInputStream(), typeReference));
        }
        catch (IOException e) {
            log.error("Could not map file to Object. \n {}", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public Optional<DataPayload> getDefaultData() {
        try {
            return Optional.ofNullable(objectMapper.readValue(this.loadDefaultTemplate(), DataPayload.class));
        }
        catch (IOException e) {
            log.error("Could not readout default NISP file template");
            return Optional.empty();
        }
    }

    private InputStream loadDefaultTemplate() {
        Resource resource = this.resourceLoader.getResource(DEFAULT_TEMPLATE_YML);
        try {
            return resource.getInputStream();
        }
        catch (IOException e) {
            log.error("PSD2 api file is not found", (Throwable)e);
            throw new IllegalArgumentException("PSD2 api file is not found");
        }
    }

    public byte[] generateFileByPayload(DataPayload data) {
        try {
            return objectMapper.writeValueAsBytes((Object)data);
        }
        catch (IOException e) {
            log.error("Could not write bytes");
            return new byte[0];
        }
    }

    public <T> List<T> convertFileToTargetObject(MultipartFile file, Class<T> target) {
        if (file == null) {
            throw new TppException("No file uploaded!", 400);
        }
        try {
            InputStreamReader streamReader = new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8);
            CsvToBean csvToBean = new CsvToBeanBuilder((Reader)streamReader).withType(target).withIgnoreLeadingWhiteSpace(true).build();
            return csvToBean.parse();
        }
        catch (IOException e) {
            log.error("Can't convert file to target class: {}", (Object)target.getSimpleName(), (Object)e);
            throw new TppException("Can't convert file to target class", 400);
        }
    }

    public ParseService(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

