/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.psd2.sandbox.tpp.rest.server.model.AccountBalance;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;

public class DataPayload {
    private List<UserTO> users;
    private List<AccountDetailsTO> accounts;
    private List<AccountBalance> balancesList;
    private List<PaymentTO> payments;
    private static final String SEPARATOR = "_";
    @JsonIgnore
    private boolean generatePayments;
    @JsonIgnore
    private String branch;
    @JsonIgnore
    private Map<String, String> generatedIbans = new HashMap();

    @JsonIgnore
    public boolean isValidPayload() {
        this.fixNullValues();
        return this.notContainsNullElements(this.users) && this.notContainsNullElements(this.accounts) && this.notContainsNullElements(this.balancesList) && this.notContainsNullElements(this.payments);
    }

    @JsonIgnore
    public Map<String, AccountDetailsTO> getAccountByIban() {
        return this.getTargetData(this.accounts, AccountDetailsTO::getIban);
    }

    @JsonIgnore
    public Map<String, AccountBalance> getBalancesByIban() {
        return this.getTargetData(this.balancesList, AccountBalance::getIban);
    }

    @JsonIgnore
    public DataPayload updatePayload(BiFunction<DataPayload, String, String> ibanGenerator, String branch, Currency currency, boolean generatePayments) {
        this.branch = branch;
        this.generatePayments = generatePayments;
        this.accounts.forEach(a -> {
            a.setIban((String)ibanGenerator.apply(this, a.getIban()));
            a.setCurrency(currency);
        });
        this.balancesList.forEach(b -> {
            b.setIban((String)ibanGenerator.apply(this, b.getIban()));
            b.setCurrency(currency);
        });
        this.users.forEach(u -> this.updateUserAndAccesses(ibanGenerator, u, branch, currency));
        return this;
    }

    private void updateUserAndAccesses(BiFunction<DataPayload, String, String> function, UserTO user, String branch, Currency currency) {
        user.setId(this.buildValue(branch, user.getId()));
        user.setEmail(this.buildValue(branch, user.getEmail()));
        user.setLogin(this.buildValue(branch, user.getLogin()));
        user.getScaUserData().forEach(d -> d.setMethodValue(this.buildValue(branch, d.getMethodValue())));
        user.getAccountAccesses().forEach(a -> {
            a.setIban((String)function.apply(this, a.getIban()));
            a.setCurrency(currency);
        });
    }

    private <T> Map<String, T> getTargetData(List<T> source, Function<T, String> function) {
        if (CollectionUtils.isEmpty(source)) {
            return new HashMap();
        }
        return source.stream().collect(Collectors.toMap(function, Function.identity()));
    }

    private void fixNullValues() {
        this.users = ListUtils.emptyIfNull((List)this.users);
        this.accounts = ListUtils.emptyIfNull((List)this.accounts);
        this.balancesList = ListUtils.emptyIfNull((List)this.balancesList);
        this.payments = ListUtils.emptyIfNull((List)this.payments);
    }

    private <T> boolean notContainsNullElements(List<T> list) {
        return !list.contains(null);
    }

    private String buildValue(String branch, String suffix) {
        return branch + SEPARATOR + suffix;
    }

    public List<UserTO> getUsers() {
        return this.users;
    }

    public List<AccountDetailsTO> getAccounts() {
        return this.accounts;
    }

    public List<AccountBalance> getBalancesList() {
        return this.balancesList;
    }

    public List<PaymentTO> getPayments() {
        return this.payments;
    }

    public boolean isGeneratePayments() {
        return this.generatePayments;
    }

    public String getBranch() {
        return this.branch;
    }

    public Map<String, String> getGeneratedIbans() {
        return this.generatedIbans;
    }

    public void setUsers(List<UserTO> users) {
        this.users = users;
    }

    public void setAccounts(List<AccountDetailsTO> accounts) {
        this.accounts = accounts;
    }

    public void setBalancesList(List<AccountBalance> balancesList) {
        this.balancesList = balancesList;
    }

    public void setPayments(List<PaymentTO> payments) {
        this.payments = payments;
    }

    public void setGeneratePayments(boolean generatePayments) {
        this.generatePayments = generatePayments;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public void setGeneratedIbans(Map<String, String> generatedIbans) {
        this.generatedIbans = generatedIbans;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataPayload)) {
            return false;
        }
        DataPayload other = (DataPayload)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$users = this.getUsers();
        List other$users = other.getUsers();
        if (this$users == null ? other$users != null : !((Object)this$users).equals(other$users)) {
            return false;
        }
        List this$accounts = this.getAccounts();
        List other$accounts = other.getAccounts();
        if (this$accounts == null ? other$accounts != null : !((Object)this$accounts).equals(other$accounts)) {
            return false;
        }
        List this$balancesList = this.getBalancesList();
        List other$balancesList = other.getBalancesList();
        if (this$balancesList == null ? other$balancesList != null : !((Object)this$balancesList).equals(other$balancesList)) {
            return false;
        }
        List this$payments = this.getPayments();
        List other$payments = other.getPayments();
        if (this$payments == null ? other$payments != null : !((Object)this$payments).equals(other$payments)) {
            return false;
        }
        if (this.isGeneratePayments() != other.isGeneratePayments()) {
            return false;
        }
        String this$branch = this.getBranch();
        String other$branch = other.getBranch();
        if (this$branch == null ? other$branch != null : !this$branch.equals(other$branch)) {
            return false;
        }
        Map this$generatedIbans = this.getGeneratedIbans();
        Map other$generatedIbans = other.getGeneratedIbans();
        return !(this$generatedIbans == null ? other$generatedIbans != null : !((Object)this$generatedIbans).equals(other$generatedIbans));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataPayload;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $users = this.getUsers();
        result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
        List $accounts = this.getAccounts();
        result = result * 59 + ($accounts == null ? 43 : ((Object)$accounts).hashCode());
        List $balancesList = this.getBalancesList();
        result = result * 59 + ($balancesList == null ? 43 : ((Object)$balancesList).hashCode());
        List $payments = this.getPayments();
        result = result * 59 + ($payments == null ? 43 : ((Object)$payments).hashCode());
        result = result * 59 + (this.isGeneratePayments() ? 79 : 97);
        String $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        Map $generatedIbans = this.getGeneratedIbans();
        result = result * 59 + ($generatedIbans == null ? 43 : ((Object)$generatedIbans).hashCode());
        return result;
    }

    public String toString() {
        return "DataPayload(users=" + this.getUsers() + ", accounts=" + this.getAccounts() + ", balancesList=" + this.getBalancesList() + ", payments=" + this.getPayments() + ", generatePayments=" + this.isGeneratePayments() + ", branch=" + this.getBranch() + ", generatedIbans=" + this.getGeneratedIbans() + ")";
    }

    public DataPayload() {
    }

    public DataPayload(List<UserTO> users, List<AccountDetailsTO> accounts, List<AccountBalance> balancesList, List<PaymentTO> payments, boolean generatePayments, String branch, Map<String, String> generatedIbans) {
        this.users = users;
        this.accounts = accounts;
        this.balancesList = balancesList;
        this.payments = payments;
        this.generatePayments = generatePayments;
        this.branch = branch;
        this.generatedIbans = generatedIbans;
    }
}

