/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.sandbox.tpp.rest.server.exception.ErrorResponse;
import de.adorsys.psd2.sandbox.tpp.rest.server.exception.TppException;
import feign.FeignException;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.HandlerMethod;

@RestControllerAdvice(basePackages={"de.adorsys.psd2.sandbox.tpp.rest.server.controller"})
public class TppExceptionAdvisor {
    private static final Logger log = LoggerFactory.getLogger(TppExceptionAdvisor.class);
    private static final String DEV_MESSAGE = "devMessage";
    private final ObjectMapper objectMapper;

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Map> handleException(Exception ex, HandlerMethod handlerMethod) {
        log.warn("Exception handled in service: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        return new ResponseEntity((Object)this.buildContentMap(500, ex.getMessage()), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={TppException.class})
    public ResponseEntity<Map> handleTppException(TppException ex, HandlerMethod handlerMethod) {
        log.warn("TppException handled in service: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        Map body = this.buildContentMap(ex.getCode(), ex.getMessage());
        return new ResponseEntity((Object)body, HttpStatus.valueOf((int)ex.getCode()));
    }

    @ExceptionHandler(value={FeignException.class})
    public ResponseEntity<Map> handleFeignException(FeignException ex, HandlerMethod handlerMethod) {
        log.warn("FeignException handled in service: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        Map body = this.buildContentMap(ex.status(), this.resolveErrorMessage(ex));
        return new ResponseEntity((Object)body, HttpStatus.valueOf((int)ex.status()));
    }

    private String resolveErrorMessage(FeignException ex) {
        try {
            if (ex.content() == null) {
                return ex.getMessage();
            }
            JsonNode tree = this.objectMapper.readTree(ex.content());
            return Optional.ofNullable(tree.get(DEV_MESSAGE)).map(JsonNode::asText).orElseGet(() -> Optional.ofNullable(tree.get("message")).map(JsonNode::asText).orElse(ex.getMessage()));
        }
        catch (IOException e) {
            log.warn("Couldn't read json content");
            return ex.getMessage();
        }
    }

    private Map<String, String> buildContentMap(int code, String message) {
        return new ErrorResponse().buildContent(code, message);
    }

    public TppExceptionAdvisor(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

