/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import de.adorsys.psd2.sandbox.tpp.rest.api.resource.TppDataUploaderRestApi;
import de.adorsys.psd2.sandbox.tpp.rest.server.exception.TppException;
import de.adorsys.psd2.sandbox.tpp.rest.server.model.DataPayload;
import de.adorsys.psd2.sandbox.tpp.rest.server.service.DownloadResourceService;
import de.adorsys.psd2.sandbox.tpp.rest.server.service.IbanGenerationService;
import de.adorsys.psd2.sandbox.tpp.rest.server.service.ParseService;
import de.adorsys.psd2.sandbox.tpp.rest.server.service.RestExecutionService;
import de.adorsys.psd2.sandbox.tpp.rest.server.service.TestsDataGenerationService;
import de.adorsys.psd2.sandbox.tpp.rest.server.service.TransactionService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Currency;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/tpp/data"})
public class TppDataUploaderController
implements TppDataUploaderRestApi {
    private static final Logger log = LoggerFactory.getLogger(TppDataUploaderController.class);
    private static final String FILE_NAME = "transactions_template.csv";
    private final RestExecutionService restExecutionService;
    private final ParseService parseService;
    private final TestsDataGenerationService generationService;
    private final IbanGenerationService ibanGenerationService;
    private final TransactionService transactionService;
    private final DownloadResourceService downloadResourceService;

    public ResponseEntity<String> uploadData(MultipartFile file) {
        log.info("Update file received");
        DataPayload parsed = (DataPayload)this.parseService.getDataFromFile(file, (TypeReference)new /* Unavailable Anonymous Inner Class!! */).orElseThrow(() -> new TppException("Could not parse data", 400));
        this.restExecutionService.updateLedgers(parsed);
        return ResponseEntity.ok((Object)"Data successfully updated");
    }

    public ResponseEntity<Resource> generateData(boolean generatePayments, String currency) {
        log.info("Request to create test data received");
        byte[] bytes = this.generationService.generate(generatePayments, Currency.getInstance(currency));
        InputStreamResource resource = new InputStreamResource((InputStream)new ByteArrayInputStream(bytes));
        HttpHeaders headers = this.getExportFileHttpHeaders();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength((long)bytes.length).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)resource);
    }

    public ResponseEntity<String> generateIban() {
        return ResponseEntity.ok((Object)this.ibanGenerationService.generateNextIban());
    }

    public ResponseEntity<Map<String, String>> uploadTransactions(MultipartFile file) {
        log.info("uploading transactions");
        Map response = this.transactionService.uploadUserTransaction(file);
        log.info("upload response contains {} errors", (Object)response.size());
        return ResponseEntity.ok((Object)response);
    }

    public ResponseEntity<Resource> downloadTransactionTemplate() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).header("Content-Disposition", new String[]{"attachment; filename=transactions_template.csv"})).body((Object)this.downloadResourceService.getResourceByTemplate(FILE_NAME));
    }

    private HttpHeaders getExportFileHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");
        headers.add("Content-Disposition", "attachment; filename=nisp_data.yml");
        return headers;
    }

    public TppDataUploaderController(RestExecutionService restExecutionService, ParseService parseService, TestsDataGenerationService generationService, IbanGenerationService ibanGenerationService, TransactionService transactionService, DownloadResourceService downloadResourceService) {
        this.restExecutionService = restExecutionService;
        this.parseService = parseService;
        this.generationService = generationService;
        this.ibanGenerationService = ibanGenerationService;
        this.transactionService = transactionService;
        this.downloadResourceService = downloadResourceService;
    }
}

