/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.controller;

import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.client.rest.DataRestClient;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtRestClient;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtStaffRestClient;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.BankCodeStructure;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.User;
import de.adorsys.psd2.sandbox.tpp.rest.api.resource.TppRestApi;
import de.adorsys.psd2.sandbox.tpp.rest.server.mapper.UserMapper;
import de.adorsys.psd2.sandbox.tpp.rest.server.service.IbanGenerationService;
import java.util.Currency;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.iban4j.CountryCode;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tpp"})
public class TppController
implements TppRestApi {
    private final UserMapper userMapper;
    private final UserMgmtStaffRestClient userMgmtStaffRestClient;
    private final UserMgmtRestClient userMgmtRestClient;
    private final DataRestClient dataRestClient;
    private final IbanGenerationService ibanGenerationService;

    public void login(String login, String pin) {
    }

    public ResponseEntity<Set<Currency>> getCurrencies() {
        return this.dataRestClient.currencies();
    }

    public ResponseEntity<List<CountryCode>> getCountryCodes() {
        return ResponseEntity.ok((Object)this.ibanGenerationService.getSupportedCountryCodes());
    }

    public ResponseEntity<Map<CountryCode, String>> getSupportedCountryCodes() {
        return ResponseEntity.ok((Object)this.ibanGenerationService.getCountryCodes());
    }

    public ResponseEntity<BankCodeStructure> getBankCodeStructure(String countryCode) {
        return ResponseEntity.ok((Object)this.ibanGenerationService.getBankCodeStructure(CountryCode.valueOf((String)countryCode)));
    }

    public ResponseEntity<Void> register(User user) {
        UserTO userTO = this.userMapper.toUserTO(user);
        this.userMgmtStaffRestClient.register(user.getId(), userTO);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }

    public ResponseEntity<Void> remove() {
        String branchId = ((UserTO)this.userMgmtRestClient.getUser().getBody()).getBranch();
        return this.dataRestClient.branch(branchId);
    }

    public ResponseEntity<Void> transactions(String accountId) {
        return this.dataRestClient.account(accountId);
    }

    public TppController(UserMapper userMapper, UserMgmtStaffRestClient userMgmtStaffRestClient, UserMgmtRestClient userMgmtRestClient, DataRestClient dataRestClient, IbanGenerationService ibanGenerationService) {
        this.userMapper = userMapper;
        this.userMgmtStaffRestClient = userMgmtStaffRestClient;
        this.userMgmtRestClient = userMgmtRestClient;
        this.dataRestClient = dataRestClient;
        this.ibanGenerationService = ibanGenerationService;
    }
}

