/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.auth;

import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtRestClient;
import de.adorsys.psd2.sandbox.tpp.rest.server.auth.AbstractAuthFilter;
import de.adorsys.psd2.sandbox.tpp.rest.server.auth.RestException;
import feign.FeignException;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;

public class TokenAuthenticationFilter
extends AbstractAuthFilter {
    private final UserMgmtRestClient ledgersUserMgmt;
    private final AuthRequestInterceptor authInterceptor;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String bearerToken = this.resolveBearerToken(request);
        if (StringUtils.isBlank((CharSequence)bearerToken)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.authenticationIsRequired()) {
            try {
                this.authInterceptor.setAccessToken(bearerToken);
                ResponseEntity validateResponse = this.ledgersUserMgmt.validate(bearerToken);
                BearerTokenTO token = (BearerTokenTO)Optional.ofNullable(validateResponse.getBody()).orElseThrow(() -> new RestException("Couldn't get bearer token"));
                this.fillSecurityContext(token);
            }
            catch (RestException | FeignException e) {
                this.handleAuthenticationFailure(response, (Exception)e);
                return;
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String resolveBearerToken(HttpServletRequest request) {
        return Optional.ofNullable(this.obtainFromHeader(request, "Authorization")).filter(StringUtils::isNotBlank).filter(t -> StringUtils.startsWithIgnoreCase((CharSequence)t, (CharSequence)"Bearer ")).map(t -> StringUtils.substringAfter((String)t, (String)"Bearer ")).orElse(null);
    }

    public TokenAuthenticationFilter(UserMgmtRestClient ledgersUserMgmt, AuthRequestInterceptor authInterceptor) {
        this.ledgersUserMgmt = ledgersUserMgmt;
        this.authInterceptor = authInterceptor;
    }
}

