/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.auth;

import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserCredentialsTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtStaffRestClient;
import de.adorsys.psd2.sandbox.tpp.rest.server.auth.AbstractAuthFilter;
import de.adorsys.psd2.sandbox.tpp.rest.server.auth.RestException;
import feign.FeignException;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;

public class LoginAuthenticationFilter
extends AbstractAuthFilter {
    private UserMgmtStaffRestClient userMgmtStaffRestClient;

    public LoginAuthenticationFilter(UserMgmtStaffRestClient userMgmtStaffRestClient) {
        this.userMgmtStaffRestClient = userMgmtStaffRestClient;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String login = this.obtainFromHeader(request, "login");
        String pin = this.obtainFromHeader(request, "pin");
        if (StringUtils.isBlank((CharSequence)login) || StringUtils.isBlank((CharSequence)pin)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.authenticationIsRequired()) {
            try {
                ResponseEntity loginResponse = this.userMgmtStaffRestClient.login(new UserCredentialsTO(login, pin, UserRoleTO.STAFF));
                BearerTokenTO bearerTokenTO = Optional.ofNullable(loginResponse.getBody()).map(SCAResponseTO::getBearerToken).orElseThrow(() -> new RestException("Couldn't get bearer token"));
                this.fillSecurityContext(bearerTokenTO);
                this.addBearerTokenHeader(bearerTokenTO.getAccess_token(), response);
            }
            catch (RestException | FeignException e) {
                this.handleAuthenticationFailure(response, (Exception)e);
                return;
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void addBearerTokenHeader(String token, HttpServletResponse response) {
        response.setHeader("access_token", token);
    }
}

