/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.utils;

import de.adorsys.psd2.sandbox.tpp.rest.server.exception.TppException;
import java.math.BigInteger;

/*
 * Exception performing whole class analysis ignored.
 */
public class IbanGenerator {
    private static final int ALLOWED_LENGTH_OF_TPP_CODE = 8;
    private static final int ALLOWED_LENGTH_OF_IBAN_SUFFIX = 2;
    private static final String COUNTRY_CODE_PREFIX = "DE";
    private static final String BANK_CODE_NISP = "76070024";
    private static final String BANK_CODE_FOR_RANDOM = "76050101";

    private IbanGenerator() {
    }

    public static String generateRandomIban(String tppCode, int ibanEnding) {
        return IbanGenerator.generateIban((String)tppCode, (String)String.format("%02d", ibanEnding), (String)"76050101");
    }

    public static String generateIbanForNispAccount(String tppCode, String ibanEnding) {
        return IbanGenerator.generateIban((String)tppCode, (String)ibanEnding, (String)"76070024");
    }

    private static String generateIban(String tppCode, String ibanEnding, String bankCode) {
        if (IbanGenerator.isDigitsAndSize((String)tppCode, (int)8) && IbanGenerator.isDigitsAndSize((String)ibanEnding, (int)2)) {
            BigInteger totalNr = new BigInteger(bankCode + tppCode + ibanEnding + "131400");
            String checkSum = String.format("%02d", 98 - totalNr.remainder(BigInteger.valueOf(97L)).intValue());
            return "DE" + checkSum + "76070024" + tppCode + ibanEnding;
        }
        throw new TppException(String.format("Inappropriate data for IBAN creation %s %s", tppCode, ibanEnding), 400);
    }

    private static boolean isDigitsAndSize(String toCheck, int size) {
        String regex = "\\d+";
        return toCheck.matches(regex) && toCheck.length() == size;
    }
}

