/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.service;

import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtRestClient;
import de.adorsys.psd2.sandbox.tpp.rest.server.exception.TppException;
import de.adorsys.psd2.sandbox.tpp.rest.server.model.DataPayload;
import de.adorsys.psd2.sandbox.tpp.rest.server.service.ParseService;
import de.adorsys.psd2.sandbox.tpp.rest.server.service.RestExecutionService;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class TestsDataGenerationService {
    private static final String MSG_NO_BRANCH_SET = "This User does not belong to any Branch";
    private static final String CAN_NOT_LOAD_DEFAULT_DATA = "Can't load default data";
    private final ParseService parseService;
    private final RestExecutionService executionService;
    private final UserMgmtRestClient userMgmtRestClient;

    public byte[] generate() {
        Optional<Object> user = Optional.ofNullable(this.userMgmtRestClient.getUser().getBody());
        String branch = user.map(UserTO::getBranch).orElseThrow(() -> new TppException(MSG_NO_BRANCH_SET, 400));
        DataPayload payload = this.parseService.getDefaultData().map(p -> p.updateIbanForBranch(branch)).orElseThrow(() -> new TppException(CAN_NOT_LOAD_DEFAULT_DATA, 400));
        this.executionService.updateLedgers(payload);
        return this.parseService.generateFileByPayload(payload);
    }

    public TestsDataGenerationService(ParseService parseService, RestExecutionService executionService, UserMgmtRestClient userMgmtRestClient) {
        this.parseService = parseService;
        this.executionService = executionService;
        this.userMgmtRestClient = userMgmtRestClient;
    }
}

