/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.server.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.psd2.sandbox.tpp.rest.server.model.AccountBalance;
import de.adorsys.psd2.sandbox.tpp.rest.server.utils.IbanGenerator;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.PredicateUtils;

public class DataPayload {
    private static final String SEPARATOR = "_";
    private List<UserTO> users;
    private List<AccountDetailsTO> accounts;
    private List<AccountBalance> balancesList;
    @JsonIgnore
    private Map<String, String> generatedIbans = new HashMap();

    public boolean isNotValidPayload() {
        return CollectionUtils.filter((Iterable)this.users, (Predicate)PredicateUtils.notNullPredicate()) || CollectionUtils.filter((Iterable)this.accounts, (Predicate)PredicateUtils.notNullPredicate()) || CollectionUtils.filter((Iterable)this.balancesList, (Predicate)PredicateUtils.notNullPredicate());
    }

    public DataPayload updateIbanForBranch(String branch) {
        CollectionUtils.emptyIfNull((Collection)this.accounts).forEach(a -> a.setIban(this.generateIban(a.getIban(), branch)));
        CollectionUtils.emptyIfNull((Collection)this.balancesList).forEach(b -> b.setIban(this.generateIban(b.getIban(), branch)));
        CollectionUtils.emptyIfNull((Collection)this.users).forEach(u -> this.updateUserIbans(u, branch));
        return this;
    }

    private void updateUserIbans(UserTO user, String branch) {
        user.setId(this.buildValue(branch, user.getId()));
        user.setEmail(this.buildValue(branch, user.getEmail()));
        user.setLogin(this.buildValue(branch, user.getLogin()));
        user.getScaUserData().forEach(d -> d.setMethodValue(this.buildValue(branch, d.getMethodValue())));
        user.getAccountAccesses().forEach(a -> a.setIban(this.generateIban(a.getIban(), branch)));
    }

    private String generateIban(String iban, String branch) {
        if (this.generatedIbans.containsKey(iban)) {
            return (String)this.generatedIbans.get(iban);
        }
        String generatedIban = IbanGenerator.generateIbanForNispAccount((String)branch, (String)iban);
        this.generatedIbans.put(iban, generatedIban);
        return generatedIban;
    }

    private String buildValue(String branch, String suffix) {
        return branch + SEPARATOR + suffix;
    }

    public List<UserTO> getUsers() {
        return this.users;
    }

    public List<AccountDetailsTO> getAccounts() {
        return this.accounts;
    }

    public List<AccountBalance> getBalancesList() {
        return this.balancesList;
    }

    public Map<String, String> getGeneratedIbans() {
        return this.generatedIbans;
    }

    public void setUsers(List<UserTO> users) {
        this.users = users;
    }

    public void setAccounts(List<AccountDetailsTO> accounts) {
        this.accounts = accounts;
    }

    public void setBalancesList(List<AccountBalance> balancesList) {
        this.balancesList = balancesList;
    }

    public void setGeneratedIbans(Map<String, String> generatedIbans) {
        this.generatedIbans = generatedIbans;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataPayload)) {
            return false;
        }
        DataPayload other = (DataPayload)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$users = this.getUsers();
        List other$users = other.getUsers();
        if (this$users == null ? other$users != null : !((Object)this$users).equals(other$users)) {
            return false;
        }
        List this$accounts = this.getAccounts();
        List other$accounts = other.getAccounts();
        if (this$accounts == null ? other$accounts != null : !((Object)this$accounts).equals(other$accounts)) {
            return false;
        }
        List this$balancesList = this.getBalancesList();
        List other$balancesList = other.getBalancesList();
        if (this$balancesList == null ? other$balancesList != null : !((Object)this$balancesList).equals(other$balancesList)) {
            return false;
        }
        Map this$generatedIbans = this.getGeneratedIbans();
        Map other$generatedIbans = other.getGeneratedIbans();
        return !(this$generatedIbans == null ? other$generatedIbans != null : !((Object)this$generatedIbans).equals(other$generatedIbans));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataPayload;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $users = this.getUsers();
        result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
        List $accounts = this.getAccounts();
        result = result * 59 + ($accounts == null ? 43 : ((Object)$accounts).hashCode());
        List $balancesList = this.getBalancesList();
        result = result * 59 + ($balancesList == null ? 43 : ((Object)$balancesList).hashCode());
        Map $generatedIbans = this.getGeneratedIbans();
        result = result * 59 + ($generatedIbans == null ? 43 : ((Object)$generatedIbans).hashCode());
        return result;
    }

    public String toString() {
        return "DataPayload(users=" + this.getUsers() + ", accounts=" + this.getAccounts() + ", balancesList=" + this.getBalancesList() + ", generatedIbans=" + this.getGeneratedIbans() + ")";
    }

    public DataPayload() {
    }

    public DataPayload(List<UserTO> users, List<AccountDetailsTO> accounts, List<AccountBalance> balancesList, Map<String, String> generatedIbans) {
        this.users = users;
        this.accounts = accounts;
        this.balancesList = balancesList;
        this.generatedIbans = generatedIbans;
    }
}

